/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry.playfield;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.util.BSPTree;
import dev.secondsun.util.BoundedCube;
import dev.secondsun.util.Resources;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class MonasteryPlayfield
implements Model {
    private final Resources resources;
    private final List<Triangle> triangles = new ArrayList<Triangle>();
    public static final int TILE_LENGTH = 16;
    private List<Triangle> ground = new ArrayList<Triangle>();
    private List<Triangle> path = new ArrayList<Triangle>();
    private List<Triangle> castle = new ArrayList<Triangle>();
    private List<Triangle> roof = new ArrayList<Triangle>();
    private BSPTree tree;
    private int textureId1;
    private int textureId2;

    public MonasteryPlayfield(Resources resources) {
        this.resources = resources;
        try {
            int imageID = resources.setImage(ImageIO.read(MonasteryPlayfield.class.getClassLoader().getResourceAsStream("water_texture.png")));
            this.textureId1 = resources.setTexture(imageID, new Vertex2D(0.0f, 0.0f), 15, 15);
            this.textureId2 = resources.setTexture(imageID, new Vertex2D(1.0f, 1.0f), -15, -15);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.drawField();
        this.drawPath();
        this.drawCastle();
        this.drawRoof();
        this.makeTree();
    }

    private void makeTree() {
        MonasteryPlayfield playfield = this;
        BoundedCube ground = new BoundedCube(playfield.field());
        BoundedCube building = new BoundedCube(playfield.castle());
        BoundedCube roof = new BoundedCube(playfield.roof());
        BoundedCube path = new BoundedCube(playfield.path());
        BSPTree tree = new BSPTree(new BSPTree.Node());
        tree.add(roof);
        tree.add(path);
        tree.add(ground);
        tree.add(building);
        this.tree = tree;
    }

    private void drawRoof() {
        int color = Color.CYAN.getRGB();
        Triangle tile = new Triangle(new Vertex(80.0f, 128.0f, 48.0f), new Vertex(80.0f, 240.0f, 48.0f), new Vertex(136.0f, 176.0f, 96.0f), color, null);
        this.triangles.add(tile);
        this.roof.add(tile);
        tile = new Triangle(new Vertex(136.0f, 176.0f, 96.0f), new Vertex(80.0f, 240.0f, 48.0f), new Vertex(208.0f, 240.0f, 48.0f), color, null);
        this.triangles.add(tile);
        this.roof.add(tile);
        tile = new Triangle(new Vertex(136.0f, 176.0f, 96.0f), new Vertex(208.0f, 240.0f, 48.0f), new Vertex(208.0f, 128.0f, 48.0f), color);
        this.triangles.add(tile);
        this.roof.add(tile);
        tile = new Triangle(new Vertex(136.0f, 176.0f, 96.0f), new Vertex(208.0f, 128.0f, 48.0f), new Vertex(80.0f, 128.0f, 48.0f), color);
        this.triangles.add(tile);
        this.roof.add(tile);
    }

    private void drawCastle() {
        for (int x = 6; x < 12; ++x) {
            Triangle southEast;
            Triangle northWest;
            boolean isOddColumn = x % 2 == 0;
            int color = 0;
            for (int y = 9; y < 14; ++y) {
                boolean isOddRow;
                boolean bl = isOddRow = y % 2 == 0;
                color = isOddColumn ? (isOddRow ? Color.RED.getRGB() : Color.ORANGE.getRGB()) : (isOddRow ? Color.ORANGE.getRGB() : Color.RED.getRGB());
                northWest = new Triangle(new Vertex(x * 16, y * 16, 48.0f), new Vertex(x * 16, (y + 1) * 16, 48.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 48.0f), color);
                southEast = new Triangle(new Vertex((x + 1) * 16, (y + 1) * 16, 48.0f), new Vertex((x + 1) * 16, y * 16, 48.0f), new Vertex(x * 16, y * 16, 48.0f), color);
                this.triangles.add(northWest);
                this.triangles.add(southEast);
                this.castle.add(northWest);
                this.castle.add(southEast);
                if (x == 6) {
                    northWest = new Triangle(new Vertex(x * 16, (y + 1) * 16, 48.0f), new Vertex(x * 16, y * 16, 48.0f), new Vertex(x * 16, y * 16, 0.0f), color);
                    southEast = new Triangle(new Vertex(x * 16, y * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 48.0f), color);
                    this.triangles.add(northWest);
                    this.triangles.add(southEast);
                    this.castle.add(northWest);
                    this.castle.add(southEast);
                    continue;
                }
                if (x != 11) continue;
                northWest = new Triangle(new Vertex((x + 1) * 16, y * 16, 48.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 48.0f), new Vertex((x + 1) * 16, y * 16, 0.0f), color);
                southEast = new Triangle(new Vertex((x + 1) * 16, (y + 1) * 16, 0.0f), new Vertex((x + 1) * 16, y * 16, 0.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 48.0f), color);
                this.triangles.add(northWest);
                this.triangles.add(southEast);
                this.castle.add(northWest);
                this.castle.add(southEast);
            }
            northWest = new Triangle(new Vertex(x * 16, 144.0f, 0.0f), new Vertex(x * 16, 144.0f, 48.0f), new Vertex((x + 1) * 16, 144.0f, 48.0f), color);
            southEast = new Triangle(new Vertex((x + 1) * 16, 144.0f, 48.0f), new Vertex((x + 1) * 16, 144.0f, 0.0f), new Vertex(x * 16, 144.0f, 0.0f), color);
            this.triangles.add(northWest);
            this.triangles.add(southEast);
            this.castle.add(northWest);
            this.castle.add(southEast);
            northWest = new Triangle(new Vertex(x * 16, 144.0f, 0.0f), new Vertex(x * 16, 144.0f, 48.0f), new Vertex((x + 1) * 16, 144.0f, 48.0f), color);
            southEast = new Triangle(new Vertex((x + 1) * 16, 144.0f, 48.0f), new Vertex((x + 1) * 16, 144.0f, 0.0f), new Vertex(x * 16, 144.0f, 0.0f), color);
            this.triangles.add(northWest);
            this.triangles.add(southEast);
            this.castle.add(northWest);
            this.castle.add(southEast);
            northWest = new Triangle(new Vertex((x + 1) * 16, 224.0f, 48.0f), new Vertex(x * 16, 224.0f, 48.0f), new Vertex(x * 16, 224.0f, 0.0f), color);
            southEast = new Triangle(new Vertex(x * 16, 224.0f, 0.0f), new Vertex((x + 1) * 16, 224.0f, 0.0f), new Vertex((x + 1) * 16, 224.0f, 48.0f), color);
            this.triangles.add(northWest);
            this.triangles.add(southEast);
            this.castle.add(northWest);
            this.castle.add(southEast);
        }
    }

    private void drawPath() {
        for (int x = 8; x < 10; ++x) {
            Triangle southEast;
            Triangle northWest;
            boolean isOddColumn = x % 2 == 0;
            int color1 = 0;
            int color2 = 0;
            for (int y = 8; y >= 0; --y) {
                boolean isOddRow = y % 2 == 0;
                color1 = this.textureId1;
                color2 = this.textureId2;
                northWest = new Triangle(new Vertex(x * 16, y * 16, 4.0f), new Vertex(x * 16, (y + 1) * 16, 4.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 4.0f), color1);
                southEast = new Triangle(new Vertex((x + 1) * 16, (y + 1) * 16, 4.0f), new Vertex((x + 1) * 16, y * 16, 4.0f), new Vertex(x * 16, y * 16, 4.0f), color2);
                this.triangles.add(northWest);
                this.triangles.add(southEast);
                this.path.add(northWest);
                this.path.add(southEast);
                if (isOddColumn) {
                    northWest = new Triangle(new Vertex(x * 16, y * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 4.0f), new Vertex(x * 16, y * 16, 4.0f), color1);
                    southEast = new Triangle(new Vertex(x * 16, y * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 4.0f), color2);
                    this.triangles.add(northWest);
                    this.triangles.add(southEast);
                    this.path.add(northWest);
                    this.path.add(southEast);
                    continue;
                }
                northWest = new Triangle(new Vertex((x + 1) * 16, y * 16, 4.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 4.0f), new Vertex((x + 1) * 16, y * 16, 0.0f), color1);
                southEast = new Triangle(new Vertex((x + 1) * 16, (y + 1) * 16, 0.0f), new Vertex((x + 1) * 16, y * 16, 0.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 4.0f), color2);
                this.triangles.add(northWest);
                this.triangles.add(southEast);
                this.path.add(northWest);
                this.path.add(southEast);
            }
            northWest = new Triangle(new Vertex(x * 16, 0.0f, 0.0f), new Vertex(x * 16, 0.0f, 4.0f), new Vertex((x + 1) * 16, 0.0f, 4.0f), color1);
            southEast = new Triangle(new Vertex((x + 1) * 16, 0.0f, 4.0f), new Vertex((x + 1) * 16, 0.0f, 0.0f), new Vertex(x * 16, 0.0f, 0.0f), color2);
            this.triangles.add(northWest);
            this.triangles.add(southEast);
            this.path.add(northWest);
            this.path.add(southEast);
        }
    }

    private void drawField() {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                boolean isOddColumn;
                int color = 0;
                boolean isOddRow = y % 2 == 0;
                boolean bl = isOddColumn = x % 2 == 0;
                color = isOddColumn ? (isOddRow ? Color.GREEN.getRGB() : new Color(0, 128, 0).getRGB()) : (isOddRow ? new Color(0, 128, 0).getRGB() : Color.GREEN.getRGB());
                Triangle northWest = new Triangle(new Vertex(x * 16, y * 16, 0.0f), new Vertex(x * 16, (y + 1) * 16, 0.0f), new Vertex((x + 1) * 16, (y + 1) * 16, 0.0f), color);
                Triangle southEast = new Triangle(new Vertex((x + 1) * 16, (y + 1) * 16, 0.0f), new Vertex((x + 1) * 16, y * 16, 0.0f), new Vertex(x * 16, y * 16, 0.0f), color);
                this.triangles.add(northWest);
                this.triangles.add(southEast);
                this.ground.add(northWest);
                this.ground.add(southEast);
            }
        }
        Triangle planSortHelper = new Triangle(new Vertex(64.0f, 64.0f, -1.0f), new Vertex(64.0f, 64.0f, -1.0f), new Vertex(64.0f, 64.0f, -1.0f), Color.black.getRGB());
        this.triangles.add(planSortHelper);
        this.ground.add(planSortHelper);
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    public Model field() {
        return Model.of(this.ground);
    }

    public Model castle() {
        return Model.of(this.castle);
    }

    public Model roof() {
        return Model.of(this.roof);
    }

    public Model path() {
        return Model.of(this.path);
    }
}

