/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry.playfield;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.util.BSPTree;
import dev.secondsun.util.BoundedCube;
import dev.secondsun.util.CubeBuilder;
import dev.secondsun.util.Resources;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class DormRoom
implements Model {
    private static final int TILE_LENGTH = 16;
    private final BSPTree root;
    private List<Triangle> triangles;
    private final Integer woodId1;
    private final Integer woodId2;
    private final Integer booksId1;
    private final Integer booksId2;
    private final Resources resources;
    private final int floorId2;
    private final int floorId1;
    private final int bedId2;
    private final int bedId1;
    private final int bedUpId2;
    private final int bedUpId1;
    private ArrayList<Triangle> floorTris;
    private ArrayList<Triangle> mattressTries;
    private ArrayList<Triangle> bookshelfTriangles;
    private ArrayList<Triangle> bedLegsTriangles;
    private ArrayList<Triangle> bedTries;

    public DormRoom(Resources resources) {
        this.resources = resources;
        try {
            int woodID = resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/wood.png")));
            int booksID = resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/books.png")));
            int floorID = resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/floor.png")));
            int bedID = resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/bed.png")));
            int bedUpID = resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/bedUp.png")));
            this.woodId1 = resources.setTexture(woodID, new Vertex2D(0.0f, 0.0f), 15, 15);
            this.woodId2 = resources.setTexture(woodID, new Vertex2D(15.0f, 15.0f), -15, -15);
            this.booksId1 = resources.setTexture(booksID, new Vertex2D(0.0f, 0.0f), 32, 47);
            this.booksId2 = resources.setTexture(booksID, new Vertex2D(32.0f, 47.0f), -32, -47);
            this.floorId1 = resources.setTexture(floorID, new Vertex2D(0.0f, 0.0f), 100, 100);
            this.floorId2 = resources.setTexture(floorID, new Vertex2D(100.0f, 100.0f), -100, -100);
            this.bedId1 = resources.setTexture(bedID, new Vertex2D(0.0f, 0.0f), 15, 31);
            this.bedId2 = resources.setTexture(bedID, new Vertex2D(15.0f, 31.0f), -15, -31);
            this.bedUpId1 = resources.setTexture(bedUpID, new Vertex2D(0.0f, 0.0f), 31, 15);
            this.bedUpId2 = resources.setTexture(bedUpID, new Vertex2D(31.0f, 15.0f), -31, -15);
            this.triangles = new ArrayList<Triangle>();
            this.bookshelf();
            this.bed();
            this.floor();
            this.root = new BSPTree();
            this.root.add(new BoundedCube(this.floorModel()));
            this.root.add(new BoundedCube(this.bookshelfModel()));
            this.root.add(new BoundedCube(this.bedModel()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void floor() {
        this.floorTris = new ArrayList();
        this.floorTris.add(new Triangle(new Vertex(0.0f, 0.0f, 0.0f), new Vertex(0.0f, 96.0f, 0.0f), new Vertex(96.0f, 96.0f, 0.0f), this.floorId1));
        this.floorTris.add(new Triangle(new Vertex(96.0f, 96.0f, 0.0f), new Vertex(96.0f, 0.0f, 0.0f), new Vertex(0.0f, 0.0f, 0.0f), this.floorId2));
        this.triangles.addAll(this.floorTris);
    }

    private void bookshelf() {
        this.bookshelfTriangles = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(0.0f, 32.0f, 0.0f), 16.0f, 36.0f, 48.0f);
        builder.setBottom1(this.woodId1).setBottom2(this.woodId2).setTop1(this.woodId1).setTop2(this.woodId2).setRight1(this.booksId1).setRight2(this.booksId2).setLeft1(this.booksId1).setLeft2(this.booksId2).setFar1(this.woodId1).setFar2(this.woodId2).disableDown();
        this.bookshelfTriangles.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.bookshelfTriangles);
    }

    private void bed() {
        this.mattress();
        this.legs();
        this.bedTries = new ArrayList();
        this.bedTries.addAll(this.mattressTries);
        this.bedTries.addAll(this.bedLegsTriangles);
    }

    private void mattress() {
        this.mattressTries = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(16.0f, 0.0f, 12.0f), 32.0f, 4.0f, 16.0f);
        builder.setBottom1(this.bedId1).setBottom2(this.bedId2).setTop1(this.bedId1).setTop2(this.bedId2).setRight1(Color.WHITE.getRGB()).setRight2(Color.WHITE.getRGB()).setLeft1(Color.cyan.getRGB()).setLeft2(Color.cyan.getRGB()).setFar1(this.bedUpId1).setFar2(this.bedUpId2).disableDown();
        this.mattressTries.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.mattressTries);
    }

    private void legs() {
        this.bedLegsTriangles = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(20.0f, 4.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setRight1(10506797).setRight2(10506797).setLeft1(10506797).setLeft2(10506797).setFar1(10506797).setFar2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(20.0f, 12.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setRight1(10506797).setRight2(10506797).setLeft1(10506797).setLeft2(10506797).setFar1(10506797).setFar2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(44.0f, 4.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setRight1(10506797).setRight2(10506797).setLeft1(10506797).setLeft2(10506797).setFar1(10506797).setFar2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(44.0f, 12.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setRight1(10506797).setRight2(10506797).setLeft1(10506797).setLeft2(10506797).setFar1(10506797).setFar2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.bedLegsTriangles);
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    public BSPTree getBSPTree() {
        return this.root;
    }

    public Model bedModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.bedTries;
            }
        };
    }

    public Model bookshelfModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.bookshelfTriangles;
            }
        };
    }

    public Model floorModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.floorTris;
            }
        };
    }
}

