/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.shortloop.agent.HttpRequest;
import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHttpClient;
import dev.shortloop.agent.buffer.AbstractBufferManager;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.Buffer;
import dev.shortloop.agent.buffer.BufferManagerWorker;
import dev.shortloop.agent.buffer.SimpleBuffer;
import dev.shortloop.agent.commons.SimpleSuccessResponse;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.common.models.data.APISample;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Semaphore;

public class DiscoveredApiBufferManager
extends AbstractBufferManager {
    private final ShortloopHttpClient shortloopHttpClient;
    private final String ctUrl;
    private final SDKLogger logger;

    public DiscoveredApiBufferManager(ConfigManager configManager, ShortloopHttpClient shortloopHttpClient, String ctUrl, SDKLogger logger) {
        super(configManager, logger);
        this.shortloopHttpClient = shortloopHttpClient;
        this.ctUrl = ctUrl;
        this.logger = logger;
    }

    @Override
    BufferManagerWorker<ApiBufferKey> createWorker(AgentConfig newConfig) {
        return new DiscoveredApiBufferManagerWorker(newConfig, this.shortloopHttpClient, this.logger);
    }

    public class DiscoveredApiBufferManagerWorker
    extends BufferManagerWorker<ApiBufferKey> {
        private final ShortloopHttpClient shortloopHttpClient;
        private final Semaphore semaphore;

        public DiscoveredApiBufferManagerWorker(AgentConfig config, ShortloopHttpClient shortloopHttpClient, SDKLogger logger) {
            super(config, DiscoveredApiBufferManager.this.ctUrl, logger);
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            this.semaphore = new Semaphore(config.getDiscoveryBufferSize());
            this.shortloopHttpClient = shortloopHttpClient;
        }

        @Override
        public boolean init() {
            return true;
        }

        @Override
        public boolean offer(ApiBufferKey apiBufferKey, APISample apiSample) {
            this.bufferMap.computeIfAbsent(apiBufferKey, key -> new SimpleBuffer(this.getOperatingConfig().getDiscoveryBufferSizePerApi()));
            Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
            if (buffer != null) {
                return buffer.offer(apiSample);
            }
            this.logger.error("Buffer found null for " + apiBufferKey.getUri());
            return false;
        }

        @Override
        public boolean canOffer(ApiBufferKey apiBufferKey) {
            if (this.semaphore.tryAcquire()) {
                boolean canOffer = false;
                if (this.getOperatingConfig().getCaptureApiSample().booleanValue()) {
                    Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
                    canOffer = null != buffer ? buffer.canOffer() : this.bufferMap.size() < this.getOperatingConfig().getDiscoveryBufferSize();
                }
                this.semaphore.release();
                return canOffer;
            }
            return false;
        }

        @Override
        void syncForKey(ApiBufferKey key) {
            try {
                Buffer buffer = (Buffer)this.bufferMap.get(key);
                if (null == buffer) {
                    this.logger.error("Buffer is null for " + key.getUri());
                    return;
                }
                int iterations = buffer.getContentCount();
                if (iterations == 0) {
                    this.bufferMap.remove(key);
                    return;
                }
                ArrayList contents = Lists.newArrayList();
                while (iterations-- > 0) {
                    APISample apiSample = buffer.poll();
                    if (null == apiSample) {
                        this.bufferMap.remove(key);
                        break;
                    }
                    contents.add(apiSample);
                }
                HashMap requestHeaders = Maps.newHashMap();
                requestHeaders.put("Content-Type", "application/json");
                HttpRequest<ArrayList, SimpleSuccessResponse> httpRequestDetail = new HttpRequest<ArrayList, SimpleSuccessResponse>(DiscoveredApiBufferManager.this.ctUrl + DiscoveredApiBufferManager.this.getUri(), contents, null, requestHeaders, new TypeReference<SimpleSuccessResponse>(){});
                SimpleSuccessResponse simpleSuccessResponse = (SimpleSuccessResponse)this.shortloopHttpClient.postRequest(httpRequestDetail).getBody();
            }
            catch (Exception exception) {
                this.logger.error("Error inside syncForKey for key " + key.getUri(), exception);
            }
        }
    }
}

