/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.commons;

import dev.shortloop.common.models.constant.ShortloopCommonConstant;
import dev.shortloop.common.models.data.AgentConfig;
import dev.shortloop.common.models.data.URI;

public class ObservedApi {
    private final URI uri;
    private final ShortloopCommonConstant.HttpRequestMethod method;

    public ObservedApi(String uriPath, ShortloopCommonConstant.HttpRequestMethod method) {
        this.uri = URI.getNonTemplatedURI((String)uriPath);
        this.method = method;
    }

    public boolean matches(AgentConfig.ApiConfig apiConfig) {
        if (apiConfig == null) {
            return false;
        }
        if (this.method != apiConfig.getMethod()) {
            return false;
        }
        return this.uri.equals((Object)apiConfig.getUri());
    }

    public ObservedApi(URI uri, ShortloopCommonConstant.HttpRequestMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public URI getUri() {
        return this.uri;
    }

    public ShortloopCommonConstant.HttpRequestMethod getMethod() {
        return this.method;
    }
}

