/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.counter;

import java.time.Duration;
import java.time.Instant;

public class TimeCounter {
    private Instant startTime = Instant.now();

    public void restart() {
        this.startTime = Instant.now();
    }

    public boolean timeElapsed(Duration duration) {
        if (duration.getSeconds() > 600L) {
            throw new IllegalArgumentException("Duration should not exceed 600 seconds");
        }
        Duration timeElapsed = Duration.between(this.startTime, Instant.now());
        return timeElapsed.getSeconds() >= duration.getSeconds();
    }

    public Duration timeElapsed() {
        return Duration.between(this.startTime, Instant.now());
    }
}

