/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvValidationException;
import com.tidal.utils.exceptions.DataResolverException;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import com.tidal.utils.scenario.ScenarioInfo;
import com.tidal.utils.utils.Helper;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvData {
    private final Logger logger = LoggerFactory.getLogger(CsvData.class);
    private String defaultDataFilePath = this.getDataFilePath();

    public void setCSVFolderAsDataFilePath() {
        this.defaultDataFilePath = Helper.getAbsoluteFromRelativePath("src/test/resources/csv") + "/";
    }

    public synchronized void updateDataTo(String dataPoolName, String key, String value) {
        String testCaseName = ScenarioInfo.getScenarioName();
        this.updateDataTo(dataPoolName, key, value, testCaseName);
    }

    public synchronized void updateDataTo(String dataPoolName, String key, String value, String testCaseName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.updateDataTo(dataPoolName, map, testCaseName);
    }

    public synchronized void updateDataTo(String dataPoolName, Map<String, String> map) {
        String testCaseName = ScenarioInfo.getScenarioName();
        this.updateData(map, dataPoolName, testCaseName);
    }

    public synchronized void updateDataTo(String dataPoolName, Map<String, String> map, String testCaseName) {
        this.updateData(map, dataPoolName, testCaseName);
    }

    public synchronized String readDataFrom(String dataPoolName, String key) {
        String testCaseName = ScenarioInfo.getScenarioName();
        return this.readDataFrom(dataPoolName, key, testCaseName);
    }

    public synchronized String readDataFrom(String dataPoolName, String key, String testcaseName) {
        return this.readData(dataPoolName, testcaseName).get(key);
    }

    public synchronized LinkedHashMap<String, String> readData(String dataPoolName) {
        String testCaseName = ScenarioInfo.getScenarioName();
        return this.readData(dataPoolName, testCaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void updateData(Map<String, String> dataMap, String dataPoolName, String testCaseName) {
        LinkedHashMap<String, String> existingDataMap;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Map<String, String> newData = dataMap;
        CsvData csvData = new CsvData();
        LinkedHashMap<String, String> newDataMap = existingDataMap = csvData.readData(dataPoolName, testCaseName);
        for (Map.Entry existingDataMapEntry : ((HashMap)existingDataMap).entrySet()) {
            for (Map.Entry<String, String> entry : newData.entrySet()) {
                String newDataMapKey;
                String existingDataMapKey = ((String)existingDataMapEntry.getKey()).trim().replace(" ", "");
                if (!existingDataMapKey.equalsIgnoreCase(newDataMapKey = entry.getKey().trim().replace(" ", ""))) continue;
                newDataMap.put((String)existingDataMapEntry.getKey(), entry.getValue());
            }
        }
        int index = 0;
        String[] values = new String[existingDataMap.size()];
        for (Map.Entry<String, String> entry : ((HashMap)newDataMap).entrySet()) {
            values[index] = entry.getValue();
            ++index;
        }
        try (CSVReader reader = new CSVReader((Reader)new FileReader(this.defaultDataFilePath + dataPoolName + ".csv"));){
            CSVWriter cSVWriter;
            Object var13_17 = null;
            try {
                String[] nextLine;
                while ((nextLine = reader.readNext()) != null) {
                    if (nextLine[0].trim().equals(testCaseName)) {
                        arrayList.add(values);
                        continue;
                    }
                    arrayList.add(nextLine);
                }
                cSVWriter = new CSVWriter((Writer)new FileWriter(this.defaultDataFilePath + dataPoolName + ".csv"));
                if (null == cSVWriter) return;
            }
            catch (CsvValidationException | IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (null != var13_17) {
                    var13_17.writeAll(arrayList);
                    var13_17.close();
                }
            }
            cSVWriter.writeAll(arrayList);
            cSVWriter.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized String getDataFilePath() {
        String csvFilePath = Helper.getAbsoluteFromRelativePath("src/test/resources/csv");
        String env = PropertiesFinder.getEnvironment();
        String filePath = csvFilePath + "/" + env + "/";
        return filePath;
    }

    protected synchronized LinkedHashMap<String, String> readData(String dataPoolName, String testCaseName) {
        String[] columnHeader = null;
        String[] nextLine = null;
        int lineNumber = 0;
        String[] dataRow = null;
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        this.logger.info("Reading data from: " + this.defaultDataFilePath + dataPoolName + ".csv");
        try (FileReader fileReader = new FileReader(this.defaultDataFilePath + dataPoolName + ".csv");){
            try (CSVReader reader = new CSVReader((Reader)fileReader);){
                while ((nextLine = reader.readNext()) != null) {
                    if (lineNumber == 0) {
                        columnHeader = nextLine;
                    }
                    ++lineNumber;
                    if (!nextLine[0].trim().equalsIgnoreCase(testCaseName.trim())) continue;
                    dataRow = nextLine;
                    this.logger.info(String.format("Found data from row %s for test case: '%s'", lineNumber, testCaseName));
                    break;
                }
                if (dataRow == null) {
                    throw new DataResolverException();
                }
                for (int index = 0; index < columnHeader.length; ++index) {
                    hashMap.put(columnHeader[index].strip(), dataRow[index].strip());
                }
            }
            catch (Exception e) {
                if (e instanceof DataResolverException) {
                    throw new DataResolverException();
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof DataResolverException) {
                String message = String.format("The test case '%s' was not found from file '%s.csv'", testCaseName, dataPoolName);
                this.logger.info(message);
            }
            e.printStackTrace();
        }
        return hashMap;
    }

    protected synchronized List<Map<String, String>> readDataAsMapList(String dataPoolName, String testCaseName) {
        String[] columnHeader = null;
        String[] nextLine = null;
        int lineNumber = 0;
        String[] dataRow = null;
        ArrayList<Map<String, String>> dataCollectionList = new ArrayList<Map<String, String>>();
        this.logger.info("Reading data from: " + this.defaultDataFilePath + dataPoolName + ".csv");
        try (FileReader fileReader = new FileReader(this.defaultDataFilePath + dataPoolName + ".csv");){
            try (CSVReader reader = new CSVReader((Reader)fileReader);){
                while ((nextLine = reader.readNext()) != null) {
                    if (lineNumber == 0) {
                        columnHeader = nextLine;
                    }
                    ++lineNumber;
                    if (!nextLine[0].trim().equalsIgnoreCase(testCaseName.trim())) continue;
                    LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
                    dataRow = nextLine;
                    this.logger.info(String.format("Found data from row %s for test case %s", lineNumber, testCaseName));
                    for (int index = 0; index < columnHeader.length; ++index) {
                        hashMap.put(columnHeader[index], dataRow[index].trim());
                    }
                    dataCollectionList.add(hashMap);
                }
                if (dataRow == null) {
                    throw new DataResolverException();
                }
            }
            catch (Exception e) {
                if (e instanceof DataResolverException) {
                    throw new DataResolverException();
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof DataResolverException) {
                String message = String.format("The test case '%s' was not found from file '%s.csv'", testCaseName, dataPoolName);
                this.logger.info(message);
            }
            e.printStackTrace();
        }
        return dataCollectionList;
    }

    protected synchronized List<Map<String, String>> readFullDataAsMapList(String dataPoolName) {
        String[] columnHeader = null;
        String[] nextLine = null;
        int lineNumber = 0;
        String[] dataRow = null;
        ArrayList<Map<String, String>> dataCollectionList = new ArrayList<Map<String, String>>();
        this.logger.info("Reading data from: " + this.defaultDataFilePath + dataPoolName + ".csv");
        try (FileReader fileReader = new FileReader(this.defaultDataFilePath + dataPoolName + ".csv");){
            try (CSVReader reader = new CSVReader((Reader)fileReader);){
                while ((nextLine = reader.readNext()) != null) {
                    if (lineNumber == 0) {
                        columnHeader = nextLine;
                    }
                    ++lineNumber;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    dataRow = nextLine;
                    for (int index = 0; index < columnHeader.length; ++index) {
                        map.put(columnHeader[index], dataRow[index].trim());
                    }
                    dataCollectionList.add(map);
                }
                if (dataRow == null) {
                    throw new DataResolverException();
                }
            }
            catch (Exception e) {
                if (e instanceof DataResolverException) {
                    throw new DataResolverException();
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof DataResolverException) {
                this.logger.info(e.getMessage());
            }
            e.printStackTrace();
        }
        return dataCollectionList;
    }
}

