/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.csv;

import com.tidal.utils.csv.CsvData;
import com.tidal.utils.data.GlobalData;
import com.tidal.utils.scenario.ScenarioInfo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResolver<T> {
    private static final Logger logger = LoggerFactory.getLogger(DataResolver.class);

    public static synchronized <T> void resolveData(T modelClass, String csvFile) {
        String testCaseName = ScenarioInfo.getScenarioName();
        DataResolver<T> dataResolver = new DataResolver<T>();
        dataResolver.resolveData(modelClass, csvFile, testCaseName);
    }

    public static synchronized Map<String, String> resolveDataAsMap(String csvFile) {
        String testCaseName = ScenarioInfo.getScenarioName();
        return new CsvData().readData(csvFile, testCaseName);
    }

    public static synchronized List<Map<String, String>> resolveDataAsMapList(String csvFile) {
        String testCaseName = ScenarioInfo.getScenarioName();
        return new CsvData().readDataAsMapList(csvFile, testCaseName);
    }

    public static synchronized List<Map<String, String>> resolveFullDataAsMapList(String csvFile) {
        return new CsvData().readFullDataAsMapList(csvFile);
    }

    public static synchronized <T> void resolveDataObject(Class<?> modelClass, String csvFile) {
        Object classInstance;
        String testCaseName = ScenarioInfo.getScenarioName();
        DataResolver dataResolver = new DataResolver();
        try {
            classInstance = Class.forName(modelClass.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        dataResolver.resolveData(classInstance, csvFile, testCaseName);
        GlobalData.addObjectData(modelClass.getSimpleName(), classInstance);
    }

    public static synchronized <T> void resolveDataObject(T modelClass, String csvFile) {
        String testCaseName = ScenarioInfo.getScenarioName();
        DataResolver<T> dataResolver = new DataResolver<T>();
        dataResolver.resolveData(modelClass, csvFile, testCaseName);
        GlobalData.addObjectData(modelClass.getClass().getSimpleName(), modelClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> void copyData(T source, T destination) {
        Objects.requireNonNull(source, "Source class instance should not be null.");
        Objects.requireNonNull(destination, "Destination class instance should not be null.");
        BeanInfo destinationClassBeanInfo = null;
        try {
            destinationClassBeanInfo = Objects.requireNonNull(Introspector.getBeanInfo(destination.getClass()));
        }
        catch (IntrospectionException e) {
            logger.warn("Introspection error: " + e.getMessage());
        }
        PropertyDescriptor[] destinationDescriptors = Objects.requireNonNull(destinationClassBeanInfo).getPropertyDescriptors();
        HashMap<String, Object> sourceValues = new HashMap<String, Object>();
        for (Field sourceField : source.getClass().getDeclaredFields()) {
            try {
                sourceField.setAccessible(true);
                sourceValues.put(sourceField.getName(), sourceField.get(source));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                sourceField.setAccessible(false);
            }
        }
        for (PropertyDescriptor destinationPropDescriptor : destinationDescriptors) {
            String propName = destinationPropDescriptor.getName();
            sourceValues.forEach((k, v) -> {
                Method setter;
                if (propName.equalsIgnoreCase((String)k) && (setter = destinationPropDescriptor.getWriteMethod()) != null) {
                    try {
                        setter.invoke(destination, v);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        logger.error(e.getMessage());
                    }
                }
            });
        }
        DataResolver.printResolvedData(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized <T> void printResolvedData(T modelClass) {
        StringBuilder fieldValues = new StringBuilder(System.lineSeparator());
        for (Field field : modelClass.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            Object value = null;
            try {
                value = field.get(modelClass);
            }
            catch (IllegalAccessException ignored) {
                logger.info(String.format("Cannot access field '%s'", name));
            }
            finally {
                field.setAccessible(false);
            }
            fieldValues.append("     ").append(name).append(" : ").append(value).append(System.lineSeparator());
        }
        logger.info(fieldValues.toString());
    }

    protected synchronized void resolveData(T modelClass, String csvFile, String testCaseName) {
        BeanInfo beaninfo = null;
        try {
            beaninfo = Introspector.getBeanInfo(modelClass.getClass());
        }
        catch (IntrospectionException e) {
            logger.warn("Introspection error: " + e.getMessage());
        }
        PropertyDescriptor[] descriptors = Objects.requireNonNull(beaninfo).getPropertyDescriptors();
        CsvData csvData = new CsvData();
        LinkedHashMap<String, String> dataMap = csvData.readData(csvFile, testCaseName);
        Set<String> columnHeaders = dataMap.keySet();
        for (PropertyDescriptor pd : descriptors) {
            String propName = pd.getName();
            for (String header : columnHeaders) {
                Method setter;
                if (!propName.equalsIgnoreCase(header.replace(" ", "")) || (setter = pd.getWriteMethod()) == null) continue;
                try {
                    setter.invoke(modelClass, dataMap.get(header));
                }
                catch (InvocationTargetException e) {
                    logger.error(e.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        DataResolver.printResolvedData(modelClass);
    }

    public synchronized List<T> resolveDataAsList(Class<?> modelClass, String csvFile) {
        return this.resolveDataAsList(modelClass, csvFile, ScenarioInfo.getScenarioName());
    }

    public synchronized List<T> resolveDataAsList(Class<?> modelClass, String csvFile, String testCaseName) {
        BeanInfo beaninfo = null;
        ArrayList<Object> classList = new ArrayList<Object>();
        CsvData csvData = new CsvData();
        List<Map<String, String>> dataMapList = csvData.readDataAsMapList(csvFile, testCaseName);
        for (Map<String, String> dataMap : dataMapList) {
            Object instance = null;
            try {
                Class<?> clazz = Class.forName(modelClass.getName());
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                beaninfo = Introspector.getBeanInfo(instance.getClass());
            }
            catch (IntrospectionException | ClassNotFoundException | InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            PropertyDescriptor[] descriptors = ((BeanInfo)Objects.requireNonNull(beaninfo)).getPropertyDescriptors();
            Set<String> columnHeaders = dataMap.keySet();
            for (PropertyDescriptor pd : descriptors) {
                String propName = pd.getName();
                for (String header : columnHeaders) {
                    Method setter;
                    if (!propName.equalsIgnoreCase(header.replace(" ", "")) || (setter = pd.getWriteMethod()) == null) continue;
                    try {
                        setter.invoke(instance, dataMap.get(header));
                    }
                    catch (InvocationTargetException e) {
                        logger.error(e.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            classList.add(instance);
        }
        return classList;
    }

    private synchronized List<String> getResolvedValues(T modelClass) {
        ArrayList<String> resolvedValues = new ArrayList<String>();
        for (Field field : modelClass.getClass().getDeclaredFields()) {
            String name = field.getName();
            Object value = null;
            try {
                value = field.get(modelClass);
                if (value != null) {
                    resolvedValues.add(value.toString());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            logger.info(name + " : " + String.valueOf(value));
        }
        return resolvedValues;
    }
}

