/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.filehandlers;

import java.nio.file.FileSystems;

public enum FilePaths {
    RESOURCE_FOLDER_PATH("src/test/resources/"),
    ERROR_OUTPUT_FOLDER("src/test/resources/error/"),
    TARGET_FOLDER_PATH("target/");

    private final String path;

    private FilePaths(String path) {
        this.path = path;
    }

    public static String getAbsoluteFromRelativePath(String path) {
        return FileSystems.getDefault().getPath(path, new String[0]).normalize().toAbsolutePath().toString();
    }

    public static String getTransformedUrlPath(FilePaths filePaths) {
        Object path = FilePaths.getAbsoluteFromRelativePath(filePaths.getPath());
        path = "file://" + (String)path;
        return path;
    }

    public String getPath() {
        return this.path;
    }
}

