/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

public class JsonWriter {
    private String jsonString;
    private final String jsonPath;
    private final String jsonDocument;

    public JsonWriter(String jsonPath, String jsonDocument) {
        this.jsonPath = jsonPath;
        this.jsonDocument = jsonDocument;
    }

    public JsonWriter setValue(Object valueToUpdate) {
        DocumentContext documentContext = JsonPath.parse((String)this.jsonDocument);
        documentContext = documentContext.set(this.jsonPath, valueToUpdate, new Predicate[0]);
        this.jsonString = documentContext.jsonString();
        return this;
    }

    public JsonWriter addToArray(String valueToUpdate) {
        DocumentContext documentContext = JsonPath.parse((String)this.jsonDocument);
        documentContext = documentContext.add(this.jsonPath, (Object)valueToUpdate, new Predicate[0]);
        this.jsonString = documentContext.jsonString();
        return this;
    }

    public JsonWriter addValue(String key, String valueToUpdate) {
        DocumentContext documentContext = JsonPath.parse((String)this.jsonDocument);
        documentContext = documentContext.put(this.jsonPath, key, (Object)valueToUpdate, new Predicate[0]);
        this.jsonString = documentContext.jsonString();
        return this;
    }

    public String extract() {
        return this.jsonString;
    }
}

