/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.junit;

import com.tidal.utils.filehandlers.FileOutWriter;
import com.tidal.utils.filehandlers.FilePaths;
import com.tidal.utils.filehandlers.FileReader;
import com.tidal.utils.junit.Template;
import com.tidal.utils.propertieshandler.Config;
import com.tidal.utils.utils.Helper;
import com.tidal.utils.xml.Processors;
import com.tidal.utils.xml.XMLReader;
import com.tidal.utils.xml.XmlBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResultParser {
    private static final Logger logger = Logger.getLogger("ResultParser");
    private static final String FINAL_RESULT_FILE = "TestResultFinal.xml";
    private static final String CURRENT_RUNNER_FILE = Config.RUNNER + ".xml";
    private static final Path TARGET_FOLDER_PATH = Paths.get(Helper.getAbsoluteFromRelativePath(FilePaths.TARGET_FOLDER_PATH.getPath()), new String[0]);
    private static final Path PATH_TO_WRITE_FILE = Paths.get(TARGET_FOLDER_PATH.toString(), "junit-reports", "TestResultFinal.xml");
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";

    private ResultParser() {
    }

    public static void parseRunnerResult() {
        logger.info("Parsing Result from first run");
        Object xmlToWrite = ResultParser.getCurrentRunnerResultXml();
        if (Config.RETRY_FAILED_TESTS) {
            List<Node> passedTests = ResultParser.getPassedTestCases();
            xmlToWrite = XML_DECLARATION + ResultParser.filterFailedTestCases(passedTests);
        }
        FileOutWriter.writeFileTo((String)xmlToWrite, PATH_TO_WRITE_FILE.toString());
    }

    public static void parseReRunnerResult() {
        logger.info("Parsing Result from retry run");
        List<Node> runnerResult = ResultParser.getTestCasesFrom(FINAL_RESULT_FILE);
        List<Node> reRunnerResult = ResultParser.getTestCasesFrom(CURRENT_RUNNER_FILE);
        String mergedXML = ResultParser.mergeResult(runnerResult, reRunnerResult);
        String failureCount = XMLReader.getValue("testsuite.@failures", ResultParser.getCurrentRunnerResultXml());
        logger.info(String.format("Combined failure count %s", failureCount));
        String totalTime = String.format("%.3f", Float.valueOf(ResultParser.getTotalRuntime(runnerResult, reRunnerResult)));
        logger.info(String.format("Total run time from first and second run %s", totalTime));
        String totalTests = String.valueOf(runnerResult.size() + reRunnerResult.size());
        logger.info(String.format("Total tests run: %s", totalTests));
        mergedXML = new XmlBuilder("testsuite", mergedXML).withUpdatedAttribute("time", totalTime).withUpdatedAttribute("failures", failureCount).withUpdatedAttribute("tests", totalTests).extract();
        FileOutWriter.writeFileTo(XML_DECLARATION + mergedXML, PATH_TO_WRITE_FILE.toString());
    }

    private static float getTotalRuntime(List<Node> runnerResult, List<Node> reRunnerResult) {
        float totalTestRunTime = 0.0f;
        float runTime = 0.0f;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        for (Node n : runnerResult) {
            try {
                runTime = numberFormat.parse(n.getAttributes().getNamedItem("time").getTextContent()).floatValue();
                totalTestRunTime += runTime;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        for (Node n : reRunnerResult) {
            try {
                runTime = numberFormat.parse(n.getAttributes().getNamedItem("time").getTextContent()).floatValue();
                totalTestRunTime += runTime;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        logger.info(String.format("Total run time is %f", Float.valueOf(totalTestRunTime)));
        return totalTestRunTime;
    }

    private static String mergeResult(List<Node> runnerResult, List<Node> reRunnerResult) {
        Node newNode;
        Document testResult = new XmlBuilder(Template.resultXMLTemplate()).getDocument();
        Element element = testResult.getDocumentElement();
        for (Node n : runnerResult) {
            newNode = element.getOwnerDocument().importNode(n, true);
            element.appendChild(newNode);
        }
        for (Node n : reRunnerResult) {
            newNode = element.getOwnerDocument().importNode(n, true);
            element.appendChild(newNode);
        }
        return Processors.transformer(testResult);
    }

    private static String filterFailedTestCases(List<Node> passedTests) {
        Document testResultTemplate = new XmlBuilder(Template.resultXMLTemplate()).getDocument();
        Element element = testResultTemplate.getDocumentElement();
        for (Node n : passedTests) {
            Node newNode = element.getOwnerDocument().importNode(n, true);
            element.appendChild(newNode);
        }
        return Processors.transformer(testResultTemplate);
    }

    public static List<Node> getTestCasesFrom(String fileName) {
        String xmlResult = FileReader.readFileToString(fileName, TARGET_FOLDER_PATH);
        return XMLReader.getNodes("testsuite.testcase", xmlResult);
    }

    private static List<Node> getPassedTestCases() {
        String xmlResult = FileReader.readFileToString(CURRENT_RUNNER_FILE, TARGET_FOLDER_PATH);
        List<Node> testCasesList = XMLReader.getNodes("testsuite.testcase", xmlResult);
        List<Node> passedTests = testCasesList.stream().filter(e -> {
            if (e == null) {
                return false;
            }
            Element element = (Element)e;
            return element.getElementsByTagName("failure").getLength() == 0;
        }).collect(Collectors.toList());
        logger.info(String.format("Passed test count is %d", passedTests.size()));
        return passedTests;
    }

    @NotNull
    private static String getCurrentRunnerResultXml() {
        return FileReader.readFileToString(CURRENT_RUNNER_FILE, TARGET_FOLDER_PATH);
    }
}

