/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.urlbuilders;

import com.tidal.utils.urlbuilders.Protocol;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Url {
    private Protocol protocol;
    private String host;
    private int port;
    private String basePath;
    private String path;
    private Map<String, String> queryParams;
    private String url;

    public String value() {
        return this.url;
    }

    private Url buildUrl() {
        String params = this.parseMap();
        this.url = this.host.replace("http://", "").replace("https://", "") + (String)(this.port >= 0 ? ":" + this.port : "") + (String)(this.basePath != null ? (!this.basePath.startsWith("/") ? "/" + this.basePath : this.basePath) : "") + (String)(this.path != null ? (!this.path.startsWith("/") ? "/" + this.path : this.path) : "") + (!params.isEmpty() ? params : "");
        this.url = this.url.replace("//", "/");
        this.url = this.protocol.getValue() + this.url;
        return this;
    }

    private String parseMap() {
        Set<String> keys = this.queryParams.keySet();
        StringBuilder queryParamPart = keys.size() > 0 ? new StringBuilder("?") : new StringBuilder();
        int counter = 0;
        for (String key : keys) {
            if (counter == 2) break;
            queryParamPart.append(key).append("=").append(this.queryParams.get(key));
            if (counter == 0 && keys.size() > 1) {
                queryParamPart.append("&");
            }
            ++counter;
        }
        return queryParamPart.toString();
    }

    public static class Builder {
        private final LinkedHashMap<String, String> queryParams = new LinkedHashMap();
        private String basePath;
        private String path;
        private int port = -1;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder queryParams(String key, String value) {
            this.queryParams.put(key, value);
            return this;
        }

        public Url build(Protocol protocol, String host) {
            Url url = new Url();
            url.protocol = protocol;
            url.host = host;
            url.port = this.port;
            url.basePath = this.basePath;
            url.path = this.path;
            url.queryParams = this.queryParams;
            return url.buildUrl();
        }
    }
}

