/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.xml;

import com.tidal.utils.exceptions.XMLHandlerException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Processors {
    private Processors() {
    }

    protected static Document docBuilder(String xmlContentString) {
        Document document;
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuildFactory.newDocumentBuilder();
            document = docBuilder.parse(new InputSource(new StringReader(xmlContentString)));
            document.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XMLHandlerException("Error parsing the document", e.getCause());
        }
        return document;
    }

    protected static NodeList getNodeList(String nodeXPath, Document document) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            return (NodeList)xpath.evaluate(nodeXPath, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new XMLHandlerException(String.format("Error parsing xpath %s", nodeXPath));
        }
    }

    public static String transformer(Document document) {
        StringWriter writer;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new XMLHandlerException("Error transforming the xml document", e.getCause());
        }
        return writer.toString();
    }

    protected static String pathParser(String path) {
        return (path.startsWith("$") ? "/" : "//") + path.replace("////", "//").replace("$", "").replace(".@", "O-py0mgJ3UqOJl3_BnyRaQ").replace("\\.", "2A8A1278-5866-4BC8-83F0-5B520BB928F4").replaceAll("\\.", "/").replace("O-py0mgJ3UqOJl3_BnyRaQ", "/@").replace("2A8A1278-5866-4BC8-83F0-5B520BB928F4", ".");
    }
}

