/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.xml;

import com.tidal.utils.exceptions.XMLHandlerException;
import com.tidal.utils.xml.Processors;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLReader {
    private XMLReader() {
    }

    public static String getValue(String path, String xmlFileContent) {
        Document document = Processors.docBuilder(xmlFileContent);
        if (path.equals("$")) {
            return document.getDocumentElement().getNodeName();
        }
        NodeList nodes = Processors.getNodeList(Processors.pathParser(path), document);
        if (nodes.getLength() == 0) {
            throw new XMLHandlerException(String.format("No node element found from the XML with the path '%s'", path));
        }
        return nodes.item(0).getTextContent();
    }

    public static List<String> getValues(String path, String xmlFileContent) {
        Document document = Processors.docBuilder(xmlFileContent);
        NodeList nodes = Processors.getNodeList(Processors.pathParser(path), document);
        ArrayList<String> values = new ArrayList<String>();
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            values.add(nodes.item(idx).getTextContent());
        }
        return values;
    }

    public static List<Node> getNodes(String path, String xmlFileContent) {
        Document document = Processors.docBuilder(xmlFileContent);
        NodeList nodes = Processors.getNodeList(Processors.pathParser(path), document);
        ArrayList<Node> values = new ArrayList<Node>();
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            values.add(nodes.item(idx));
        }
        return values;
    }

    public static NodeList getNodesList(String path, String xmlFileContent) {
        Document document = Processors.docBuilder(xmlFileContent);
        return Processors.getNodeList(Processors.pathParser(path), document);
    }
}

