/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.utils.xml;

import com.tidal.utils.exceptions.XMLHandlerException;
import com.tidal.utils.utils.CheckString;
import com.tidal.utils.xml.Processors;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBuilder {
    private String nodeXPath = "$";
    private String xmlFileContent;

    public XmlBuilder(String nodeXPath, String xmlFileContent) {
        this.xmlFileContent = xmlFileContent;
        this.nodeXPath = Processors.pathParser(nodeXPath);
    }

    public XmlBuilder(String xmlFileContent) {
        this.xmlFileContent = xmlFileContent;
        this.nodeXPath = Processors.pathParser(this.nodeXPath);
    }

    public String extract() {
        return this.xmlFileContent;
    }

    public XmlBuilder newPath(String newXPath) {
        this.nodeXPath = Processors.pathParser(newXPath);
        return this;
    }

    public XmlBuilder withNewNodeContent(String newNodeTextValue) {
        Document document = Processors.docBuilder(this.xmlFileContent);
        document.getDocumentElement().normalize();
        NodeList nodes = Processors.getNodeList(this.nodeXPath, document);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            nodes.item(idx).setTextContent(newNodeTextValue);
        }
        this.xmlFileContent = Processors.transformer(document);
        return this;
    }

    public XmlBuilder withUpdatedAttribute(String attribute, String newAttributeValue) {
        Document document = Processors.docBuilder(this.xmlFileContent);
        document.getDocumentElement().normalize();
        NodeList nodes = Processors.getNodeList(this.nodeXPath, document);
        for (int index = 0; index < nodes.getLength(); ++index) {
            NamedNodeMap attributes = nodes.item(index).getAttributes();
            Node attrib = attributes.getNamedItem(attribute);
            if (attributes.getLength() == 0) {
                throw new XMLHandlerException(String.format("No attribute found with name %s and xpath %s", attribute, this.nodeXPath));
            }
            attrib.setTextContent(newAttributeValue);
        }
        this.xmlFileContent = Processors.transformer(document);
        return this;
    }

    public XmlBuilder withAppendedNode(String newNodeToAppend, String newNodeTextValue) {
        return this.withAppendedNode(newNodeToAppend, newNodeTextValue, null, null);
    }

    public XmlBuilder withAppendedNode(String newNodeToAppend, String newAttribute, String newAttributeValue) {
        return this.withAppendedNode(newNodeToAppend, "", newAttribute, newAttributeValue);
    }

    public XmlBuilder withAppendedNode(String newNodeToAppend, String newNodeTextValue, String newAttribute, String newAttributeValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CheckString.isNullOrEmpty(newAttribute) && !CheckString.isNullOrEmpty(newAttributeValue)) {
            map.put(newAttribute, newAttributeValue);
        }
        return this.withAppendedNode(newNodeToAppend, newNodeTextValue, map);
    }

    public XmlBuilder withAppendedNode(String newNodeToAppend, String newNodeTextValue, Map<String, String> attributes) {
        Document document = Processors.docBuilder(this.xmlFileContent);
        Element newNode = document.createElement(newNodeToAppend);
        newNode.appendChild(document.createTextNode(newNodeTextValue));
        if (!attributes.isEmpty()) {
            attributes.forEach(newNode::setAttribute);
        }
        Node node = Processors.getNodeList(this.nodeXPath, document).item(0);
        node.appendChild(newNode);
        this.xmlFileContent = Processors.transformer(document);
        return this;
    }

    public Document getDocument() {
        return Processors.docBuilder(this.xmlFileContent);
    }
}

