package fi.evolver.script.app;

import java.net.URI;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;

public class Kubectl {

	private static final String KUBERNETES_KEYRING_NAME = "kubernetes-apt-keyring.gpg";

	/**
	 * @param kubectlVersion The kubectl version e.g. 1.32
	 */
	public static void install(String kubectlVersion) {
		try (Step step = Step.start("Kubectl: install")) {

			Apt.addPublicKey(KUBERNETES_KEYRING_NAME, URI.create(
					"https://pkgs.k8s.io/core:/stable:/v%s/deb/Release.key".formatted(kubectlVersion)));

			Apt.addSource("kubernetes", "deb [signed-by=/etc/apt/keyrings/%s] https://pkgs.k8s.io/core:/stable:/v%s/deb/ /"
					.formatted(KUBERNETES_KEYRING_NAME, kubectlVersion));

			Apt.update();
			Apt.install("kubectl");

			FileUtils.writeShellBlock(Shell.BASHRC, "kubectl config", """
					source <(kubectl completion bash)
					alias k=kubectl
					complete -o default -F __start_kubectl k
					""");
		}
	}

}
