package fi.evolver.script.app;

import java.net.URI;

import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.system.Debian;

public class Docker {

	private static final String KEYRING_NAME = "docker.gpg";

	public static void install() {
		try (Step step = Step.start("Docker: install")) {
			Apt.addPublicKey(KEYRING_NAME, URI.create("https://download.docker.com/linux/debian/gpg"));
			Apt.addSource("docker",
					"deb [arch=%s signed-by=/etc/apt/keyrings/%s] https://download.docker.com/linux/debian %s stable"
							.formatted(
									Apt.getArchitecture(),
									KEYRING_NAME,
									Debian.codename()
							)
			);

			Apt.purge("docker.io", "docker-doc", "docker-compose", "podman-docker", "containerd", "runc");
			Apt.update();
			Apt.install("docker-ce", "docker-ce-cli", "containerd.io", "docker-buildx-plugin", "docker-compose-plugin");
		}
	}

	public static void addCurrentUserToDockerGroup() {
		addUserToDockerGroup(Shell.USER);
	}

	public static void addUserToDockerGroup(String user) {
		try (Step step = Step.start("Docker: add %s to docker group".formatted(user))) {
			Shell.sudo("usermod", "-aG", "docker", user);
		}
	}
}

