/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import com.google.gson.Gson;
import fi.evolver.script.Dialog;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Nvm;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SequencedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bitwarden {
    private static final Pattern REGEX_BW_SESSION = Pattern.compile("\\$ export BW_SESSION=\"(?<sessionId>[^\"]+)\"\n");
    private static final Gson GSON = new Gson();
    private static String email = System.getenv("BITWARDEN_EMAIL");
    private static String sessionId;
    private static Nvm.Node node;
    private static final Dialog.DialogEntry DIALOG_EMAIL;
    private static final Dialog.DialogEntry DIALOG_PASSWORD;
    private static final Dialog.DialogEntry DIALOG_MFA;

    public static void install() {
        try (Step step = Step.start("Bitwarden: install");){
            node = Nvm.use("20");
            if (Files.isExecutable(node.bin().resolve("bw"))) {
                step.skip("Already installed");
                return;
            }
            node.npm("install", "-g", "@bitwarden/cli");
        }
    }

    private static void startSession(Step step) {
        if (sessionId != null) {
            return;
        }
        Bitwarden.install();
        boolean needLogin = Bitwarden.command("status").contains("\"status\":\"unauthenticated\"");
        Dialog dialog = new Dialog("Bitwarden login");
        if (needLogin && email == null) {
            dialog.add(DIALOG_EMAIL);
        }
        dialog.add(DIALOG_PASSWORD);
        if (needLogin) {
            dialog.add(DIALOG_MFA);
        }
        SequencedMap<Dialog.DialogEntry, String> values = dialog.show();
        String result = needLogin ? Bitwarden.command("login", values.getOrDefault(DIALOG_EMAIL, email), (String)values.get(DIALOG_PASSWORD), "--method", "0", "--code", (String)values.get(DIALOG_MFA)) : Bitwarden.command("unlock", (String)values.get(DIALOG_PASSWORD));
        Matcher matcher = REGEX_BW_SESSION.matcher(result);
        if (!matcher.find()) {
            step.fail("Failed opening the Bitwarden vault");
        }
        sessionId = matcher.group("sessionId");
    }

    private static String command(String ... args) {
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(node.bin().resolve("bw").toString());
        fullCommand.addAll(Arrays.asList(args));
        Shell.Command command = node.command(fullCommand);
        if (sessionId != null) {
            command.env("BW_SESSION", sessionId);
        }
        return command.run().stdout();
    }

    public static void sync() {
        try (Step step = Step.start("Bitwarden: sync");){
            Bitwarden.startSession(step);
            Bitwarden.command("sync");
        }
    }

    public static BitwardenItem getItem(String id) {
        try (Step step = Step.start("Bitwarden: get item %s".formatted(id));){
            Bitwarden.startSession(step);
            BitwardenItem bitwardenItem = (BitwardenItem)GSON.fromJson(Bitwarden.command("get", "item", id), BitwardenItem.class);
            return bitwardenItem;
        }
    }

    static {
        DIALOG_EMAIL = Dialog.textField("Email address");
        DIALOG_PASSWORD = Dialog.passwordField("Password");
        DIALOG_MFA = Dialog.passwordField("MFA");
    }

    public record BitwardenItem(String id, String name, String notes, List<Field> fields, Login login) {
        public String getField(String name) {
            return this.fields.stream().filter(f -> name.equals(f.name())).map(Field::value).findFirst().orElse(null);
        }
    }

    public record Field(String name, String value) {
    }

    public record Login(String username, String password) {
    }
}

