/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.system;

import fi.evolver.script.Shell;

public enum Hypervisor {
    NONE("none"),
    UNKNOWN(""),
    ACRN("acrn"),
    AMAZON("amazon"),
    APPLE("apple"),
    BHYVE("bhyve"),
    BOCHS("bochs"),
    CONTAINER_OTHER("container-other"),
    DOCKER("docker"),
    GOOGLE("google"),
    KVM("kvm"),
    LXC("lxc"),
    LXC_LIBVIRT("lxc-libvirt"),
    MICROSOFT("microsoft"),
    OPENVZ("openvz"),
    ORACLE("oracle"),
    PARALLELS("parallels"),
    PODMAN("podman"),
    POUCH("pouch"),
    POWERVM("powervm"),
    PROOT("proot"),
    QEMU("qemu"),
    QNX("qnx"),
    RKT("rkt"),
    SRE("sre"),
    SYSTEMD_NSPAWN("systemd-nspawn"),
    UML("uml"),
    VMWARE("vmware"),
    VM_OTHER("vm-other"),
    WSL("wsl"),
    XEN("xen"),
    ZVM("zvm");

    private final String code;

    private Hypervisor(String code) {
        this.code = code;
    }

    public static Hypervisor current() {
        String hypervisor = Shell.user("systemd-detect-virt").strip();
        for (Hypervisor candidate : Hypervisor.values()) {
            if (!candidate.code.equalsIgnoreCase(hypervisor)) continue;
            return candidate;
        }
        return UNKNOWN;
    }

    public String getCode() {
        return this.code;
    }
}

