/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.processor.poet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import graphics.glimpse.processor.poet.model.AttributeModel;
import graphics.glimpse.processor.poet.model.ShaderParamsModel;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001dH\u0002J\u001a\u0010 \u001a\u00020\u001d*\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgraphics/glimpse/processor/poet/DrawMeshFunPoet;", "", "()V", "COMMENT_CLEANUP", "", "COMMENT_DRAWING", "FUNCTION_NAME_DRAW_MESH", "PARAM_NAME_GL_ADAPTER", "PARAM_NAME_MESH", "STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL", "STATEMENT_FORMAT_ATTRIBUTE_POINTER", "STATEMENT_FORMAT_DISABLE_ATTRIBUTE", "STATEMENT_FORMAT_DRAW_ARRAYS", "STATEMENT_FORMAT_ENABLE_ATTRIBUTE", "STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION", "STATEMENT_FORMAT_USE_MESH_BUFFER", "glimpseAdapterClassName", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "meshClassName", "attributeLocation", "Lcom/squareup/javapoet/CodeBlock;", "attribute", "Lgraphics/glimpse/processor/poet/model/AttributeModel;", "generateFun", "Lcom/squareup/javapoet/MethodSpec;", "model", "Lgraphics/glimpse/processor/poet/model/ShaderParamsModel;", "addAttributeStatement", "Lcom/squareup/javapoet/MethodSpec$Builder;", "addEmptyLine", "", "generateStatements", "attributes", "", "processor-java"})
public final class DrawMeshFunPoet {
    private static final String FUNCTION_NAME_DRAW_MESH = "drawMesh";
    private static final String PARAM_NAME_GL_ADAPTER = "gl";
    private static final String PARAM_NAME_MESH = "mesh";
    private static final String STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION = "int $L = getAttributeLocation(gl, $S)";
    private static final String STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL = "$LLocation";
    private static final String STATEMENT_FORMAT_USE_MESH_BUFFER = "$N.useBuffer(gl, $L)";
    private static final String STATEMENT_FORMAT_ENABLE_ATTRIBUTE = "gl.glEnableVertexAttribArray($L)";
    private static final String STATEMENT_FORMAT_ATTRIBUTE_POINTER = "glVertexAttribPointer(gl, $L, $L)";
    private static final String STATEMENT_FORMAT_DISABLE_ATTRIBUTE = "gl.glDisableVertexAttribArray($L)";
    private static final String STATEMENT_FORMAT_DRAW_ARRAYS = "$N.draw(gl)";
    private static final String COMMENT_DRAWING = "Drawing vertices:";
    private static final String COMMENT_CLEANUP = "Disabling arrays:";
    private static final ClassName glimpseAdapterClassName;
    private static final ClassName meshClassName;
    @NotNull
    public static final DrawMeshFunPoet INSTANCE;

    @NotNull
    public final MethodSpec generateFun(@NotNull ShaderParamsModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)FUNCTION_NAME_DRAW_MESH).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)glimpseAdapterClassName, PARAM_NAME_GL_ADAPTER, new Modifier[0]).addParameter((TypeName)meshClassName, PARAM_NAME_MESH, new Modifier[0]);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"MethodSpec.methodBuilder\u2026assName, PARAM_NAME_MESH)");
        MethodSpec methodSpec = this.generateStatements(builder, model.getAttributes()).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026tes)\n            .build()");
        return methodSpec;
    }

    private final MethodSpec.Builder generateStatements(MethodSpec.Builder $this$generateStatements, List<AttributeModel> attributes) {
        for (AttributeModel attribute : attributes) {
            $this$generateStatements.addComment(attribute.getComment(), new Object[0]);
            this.addAttributeStatement($this$generateStatements, attribute);
            this.addEmptyLine($this$generateStatements);
        }
        $this$generateStatements.addComment(COMMENT_DRAWING, new Object[0]);
        $this$generateStatements.addStatement(STATEMENT_FORMAT_DRAW_ARRAYS, new Object[]{PARAM_NAME_MESH});
        this.addEmptyLine($this$generateStatements);
        $this$generateStatements.addComment(COMMENT_CLEANUP, new Object[0]);
        for (AttributeModel attribute : attributes) {
            $this$generateStatements.addStatement(STATEMENT_FORMAT_DISABLE_ATTRIBUTE, new Object[]{this.attributeLocation(attribute)});
        }
        return $this$generateStatements;
    }

    private final MethodSpec.Builder addAttributeStatement(MethodSpec.Builder $this$addAttributeStatement, AttributeModel attribute) {
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION, new Object[]{this.attributeLocation(attribute), attribute.getName()});
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_USE_MESH_BUFFER, new Object[]{PARAM_NAME_MESH, attribute.getArrayBufferIndex()});
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_ENABLE_ATTRIBUTE, new Object[]{this.attributeLocation(attribute)});
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_ATTRIBUTE_POINTER, new Object[]{this.attributeLocation(attribute), attribute.getVectorSize()});
        return $this$addAttributeStatement;
    }

    private final CodeBlock attributeLocation(AttributeModel attribute) {
        CodeBlock codeBlock = CodeBlock.of((String)STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL, (Object[])new Object[]{attribute.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)codeBlock, (String)"CodeBlock.of(STATEMENT_F\u2026TION_VAL, attribute.name)");
        return codeBlock;
    }

    private final void addEmptyLine(MethodSpec.Builder $this$addEmptyLine) {
        $this$addEmptyLine.addCode("\n", new Object[0]);
    }

    private DrawMeshFunPoet() {
    }

    static {
        DrawMeshFunPoet drawMeshFunPoet;
        INSTANCE = drawMeshFunPoet = new DrawMeshFunPoet();
        glimpseAdapterClassName = ClassName.get((String)"graphics.glimpse", (String)"GlimpseAdapter", (String[])new String[0]);
        meshClassName = ClassName.get((String)"graphics.glimpse.meshes", (String)"Mesh", (String[])new String[0]);
    }
}

