/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.JsonSchemaDraft;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import dorkbox.annotation.AnnotationDefaults;
import dorkbox.annotation.AnnotationDetector;
import io.bindingz.api.annotations.Contract;
import io.bindingz.api.model.ContractDto;
import io.bindingz.api.model.ContractSchema;
import io.bindingz.api.model.JsonSchemaSpec;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ContractService {
    private final ObjectMapper mapper;

    public ContractService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Collection<ContractDto> create(ClassLoader classLoader, String ... packageNames) throws IOException {
        List contractClasses = AnnotationDetector.scanClassPath((ClassLoader)classLoader, (String[])packageNames).forAnnotations(Contract.class).on(ElementType.TYPE).collect(AnnotationDefaults.getType);
        return contractClasses.stream().map(clazz -> this.createResource((Class)clazz)).collect(Collectors.toList());
    }

    private ContractDto createResource(Class contract) {
        JsonSchemaGenerator generator = new JsonSchemaGenerator(this.mapper, JsonSchemaConfig.vanillaJsonSchemaDraft4().withJsonSchemaDraft(this.version(JsonSchemaSpec.DRAFT_04)));
        HashMap<JsonSchemaSpec, JsonNode> schemas = new HashMap<JsonSchemaSpec, JsonNode>();
        schemas.put(JsonSchemaSpec.DRAFT_04, generator.generateJsonSchema(contract));
        Contract owner = contract.getAnnotation(Contract.class);
        return new ContractDto(owner.namespace(), owner.owner(), owner.contractName(), owner.version(), new ContractSchema(schemas));
    }

    private JsonSchemaDraft version(JsonSchemaSpec spec) {
        return JsonSchemaDraft.valueOf((String)spec.name());
    }
}

