/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client.credentials;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bindingz.api.client.credentials.ApiCredentials;
import io.bindingz.api.client.credentials.ApiCredentialsLoader;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class FileCredentialsLoader
implements ApiCredentialsLoader {
    private final File location;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public FileCredentialsLoader(File location) {
        this.location = location;
    }

    @Override
    public Optional<String> apiKey() {
        if (this.location.exists()) {
            try {
                ApiCredentials credentials = (ApiCredentials)OBJECT_MAPPER.readValue(this.location, ApiCredentials.class);
                return Optional.ofNullable(credentials.getApiKey());
            }
            catch (IOException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> hostname() {
        if (this.location.exists()) {
            try {
                ApiCredentials credentials = (ApiCredentials)OBJECT_MAPPER.readValue(this.location, ApiCredentials.class);
                return Optional.ofNullable(credentials.getHostname());
            }
            catch (IOException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

