/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.source.code.provider.jsonschematopojo;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bindingz.api.configuration.SourceCodeConfiguration;
import io.bindingz.api.model.ContractDto;
import io.bindingz.api.model.JsonSchemaSpec;
import io.bindingz.api.model.SourceDto;
import io.bindingz.source.code.SourceCodeProviderException;
import io.bindingz.source.code.provider.SourceCodeProvider;
import io.bindingz.source.code.provider.jsonschematopojo.JsonSchema2PojoConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jsonschema2Pojo;

public class JsonSchema2PojoProvider
implements SourceCodeProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<SourceDto> create(ContractDto contractDto, SourceCodeConfiguration configuration) throws SourceCodeProviderException {
        try {
            File targetDirectory = this.createTargetDirectory();
            String config = this.mapper.writeValueAsString((Object)configuration.getProviderConfiguration());
            JsonSchema2PojoConfiguration factoryConfig = (JsonSchema2PojoConfiguration)this.mapper.readValue(config, JsonSchema2PojoConfiguration.class);
            factoryConfig.setTargetSourceDirectory(targetDirectory);
            factoryConfig.setTargetResourceDirectory(this.createResourceDirectory(contractDto, configuration));
            factoryConfig.setPackageName(configuration.getPackageName());
            factoryConfig.setClassName(configuration.getClassName());
            Jsonschema2Pojo.generate((GenerationConfig)factoryConfig);
            return Files.walk(targetDirectory.toPath(), new FileVisitOption[0]).filter(f -> Files.isRegularFile(f, new LinkOption[0])).map(f -> new SourceDto(this.file(targetDirectory.toPath(), (Path)f), this.contents((Path)f))).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SourceCodeProviderException("Unable to create source code", e);
        }
    }

    private String contents(Path file) {
        try {
            return new String(Files.readAllBytes(file));
        }
        catch (IOException e) {
            return "";
        }
    }

    private List<String> file(Path root, Path source) {
        ArrayList<String> parts = new ArrayList<String>();
        root.relativize(source).iterator().forEachRemaining(p -> parts.add(p.getFileName().toString()));
        return parts;
    }

    private File createResourceDirectory(ContractDto contractDto, SourceCodeConfiguration configuration) throws IOException {
        File tempRoot = File.createTempFile("resource-", ".schema");
        tempRoot.delete();
        tempRoot.mkdir();
        File targetResourceDirectory = Paths.get(tempRoot.toString(), configuration.getClassName() + ".jsd").toFile();
        this.mapper.writeValue(targetResourceDirectory, contractDto.getSchema().getSpecs().get(JsonSchemaSpec.DRAFT_04));
        return tempRoot;
    }

    private File createTargetDirectory() throws IOException {
        File targetSourceDirectory = File.createTempFile("target-", ".source");
        targetSourceDirectory.delete();
        targetSourceDirectory.mkdir();
        return targetSourceDirectory;
    }
}

