/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.codeql;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import io.codemodder.CodeDirectory;
import io.codemodder.RuleSarif;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeQLRuleSarif
implements RuleSarif {
    private final SarifSchema210 sarif;
    private final String ruleId;
    private final Map<Path, List<Result>> resultsCache;
    private final Path repositoryRoot;
    static final String toolName = "CodeQL";
    private static final Logger logger = LoggerFactory.getLogger(CodeQLRuleSarif.class);

    public CodeQLRuleSarif(String ruleId, SarifSchema210 sarif, CodeDirectory codeDirectory) {
        this.sarif = Objects.requireNonNull(sarif);
        this.ruleId = Objects.requireNonNull(ruleId);
        this.repositoryRoot = codeDirectory.asPath();
        this.resultsCache = new HashMap<Path, List<Result>>();
    }

    private String extractRuleId(Result result, Run run) {
        if (result.getRuleId() == null) {
            Integer toolIndex = result.getRule().getToolComponent().getIndex();
            Integer ruleIndex = result.getRule().getIndex();
            Optional<String> maybeRule = run.getTool().getExtensions().stream().skip(toolIndex.intValue()).findFirst().flatMap(tool -> tool.getRules().stream().skip(ruleIndex.intValue()).findFirst()).map(rd -> rd.getId());
            if (maybeRule.isPresent()) {
                return maybeRule.get();
            }
            return null;
        }
        return result.getRuleId();
    }

    public List<Region> getRegionsFromResultsByRule(Path path) {
        return this.getResultsByLocationPath(path).stream().map(result -> ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion()).collect(Collectors.toUnmodifiableList());
    }

    public List<Result> getResultsByLocationPath(Path path) {
        if (this.resultsCache.containsKey(path)) {
            return this.resultsCache.get(path);
        }
        List<Result> results = this.sarif.getRuns().stream().flatMap(run -> run.getResults().stream().filter(result -> this.ruleId.equals(this.extractRuleId((Result)result, (Run)run)))).filter(result -> {
            String uri = ((Location)result.getLocations().get(0)).getPhysicalLocation().getArtifactLocation().getUri();
            try {
                Path uriPath = Path.of(uri, new String[0]);
                if (Files.exists(this.repositoryRoot.resolve(uriPath), new LinkOption[0])) {
                    return Files.isSameFile(path, this.repositoryRoot.resolve(uriPath));
                }
                return false;
            }
            catch (IOException e) {
                logger.error("Problem inspecting SARIF to find code results", (Throwable)e);
                return false;
            }
        }).toList();
        this.resultsCache.put(path, results);
        return results;
    }

    public SarifSchema210 rawDocument() {
        return this.sarif;
    }

    public String getRule() {
        return this.ruleId;
    }

    public String getDriver() {
        return toolName;
    }
}

