/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import io.codemodder.codetf.DetectorRule;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Finding {
    private final String id;
    private final DetectorRule rule;

    Finding(String id, DetectorRule rule) {
        this.id = id;
        this.rule = Objects.requireNonNull(rule);
    }

    Finding(DetectorRule rule) {
        this(null, rule);
    }

    public String getId() {
        return this.id;
    }

    public DetectorRule getRule() {
        return this.rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Finding finding = (Finding)o;
        return Objects.equals(this.id, finding.id) && this.rule.equals(finding.rule);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.id);
        result = 31 * result + this.rule.hashCode();
        return result;
    }
}

