/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class Data
extends Item {
    public static final String HEADER = "DAT";
    protected String payload;
    private static final List<Claim> openClaims = List.of(Claim.AMB, Claim.AUD, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.KID, Claim.MIM, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 3;
    private static final int MAXIMUM_NBR_COMPONENTS = 4;
    private static final int COMPONENTS_PAYLOAD_INDEX = 2;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Data(UUID issuerId) {
        this(issuerId, -1L, null);
    }

    public Data(UUID issuerId, long validFor) {
        this(issuerId, validFor, null);
    }

    public Data(UUID issuerId, String context) {
        this(issuerId, -1L, context);
    }

    public Data(UUID issuerId, long validFor, String context) {
        if (issuerId == null) {
            throw new IllegalArgumentException("Issuer identifier must not be null.");
        }
        if (context != null && context.length() > 84) {
            throw new IllegalArgumentException("Context must not be longer than 84.");
        }
        this.putClaim(Claim.UID, UUID.randomUUID());
        this.putClaim(Claim.ISS, issuerId);
        Instant iat = Utility.createTimestamp();
        this.putClaim(Claim.IAT, iat);
        if (validFor != -1L) {
            Instant exp = iat.plusSeconds(validFor);
            this.putClaim(Claim.EXP, exp);
        }
        this.putClaim(Claim.CTX, context);
    }

    public void setPayload(byte[] payload) {
        this.setPayload(payload, null);
    }

    public void setPayload(byte[] payload, String mimeType) {
        this.throwIfSigned();
        this.payload = Utility.toBase64(payload);
        this.putClaim(Claim.MIM, mimeType);
    }

    public byte[] getPayload() {
        return Utility.fromBase64(this.payload);
    }

    @Override
    public void sign(Key key) throws CryptographyException {
        if (this.payload == null) {
            throw new IllegalStateException("Unable to sign item, no payload added.");
        }
        super.sign(key);
    }

    @Override
    public IntegrityState verify(Key trustedKey, List<Item> linkedItems) {
        if (this.payload == null || this.payload.length() == 0) {
            throw new IllegalStateException("Unable to verify message, no payload added.");
        }
        return super.verify(trustedKey, linkedItems);
    }

    @Override
    public String thumbprint() throws CryptographyException {
        if (this.payload == null) {
            throw new IllegalStateException("Unable to generate thumbprint, no payload added.");
        }
        return super.thumbprint();
    }

    Data() {
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return openClaims.contains((Object)claim);
    }

    @Override
    protected void customDecoding(List<String> components) throws InvalidFormatException {
        if (components.size() > 4) {
            throw new InvalidFormatException("More components in item than expected, got " + components.size() + ", expected maximum 4");
        }
        this.payload = components.get(2);
        this.isSigned = components.size() == 4;
    }

    @Override
    protected void customEncoding(StringBuilder builder) throws InvalidFormatException {
        super.customEncoding(builder);
        builder.append(".");
        builder.append(this.payload);
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 3;
    }
}

