/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.Signature;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Envelope
extends Item {
    @Deprecated
    public static final int MAX_CONTEXT_LENGTH = 84;
    public static final String HEADER = "Di";
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.KID, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private ArrayList<Item> items;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public List<Item> getItems() {
        return this.items != null ? Collections.unmodifiableList(this.items) : null;
    }

    public boolean isAnonymous() {
        return !this.hasClaims();
    }

    public Envelope() {
    }

    public Envelope(UUID issuerId) {
        this(issuerId, null);
    }

    public Envelope(UUID issuerId, String context) {
        if (issuerId == null) {
            throw new IllegalArgumentException("Issuer id may not be null.");
        }
        if (context != null && context.length() > 84) {
            throw new IllegalArgumentException("Context must not be longer than 84.");
        }
        this.putClaim(Claim.ISS, issuerId);
        this.putClaim(Claim.IAT, Utility.createTimestamp());
        this.putClaim(Claim.CTX, context);
    }

    public static Envelope importFromEncoded(String encoded) throws InvalidFormatException {
        if (!encoded.startsWith(HEADER)) {
            throw new InvalidFormatException("Not a Dime envelope object, invalid header.");
        }
        String[] sections = encoded.split(":");
        String[] array = sections[0].split("\\.");
        Envelope envelope = new Envelope();
        envelope.components = new ArrayList<String>(Arrays.asList(array));
        ArrayList items = new ArrayList(sections.length);
        for (int index = 1; index < sections.length; ++index) {
            Object item = Item.fromEncoded(sections[index]);
            if (item == null) {
                if (index == sections.length - 1) {
                    envelope.isSigned = true;
                    continue;
                }
                throw new InvalidFormatException("Unable to import envelope, encountered invalid items.");
            }
            items.add(item);
        }
        envelope.items = items;
        if (!envelope.isSigned()) {
            envelope.encoded = encoded;
        } else {
            envelope.isSigned = true;
            envelope.components.add(sections[sections.length - 1]);
            envelope.encoded = encoded.substring(0, encoded.lastIndexOf(":"));
            if (envelope.getSignatures().get(0).isLegacy()) {
                envelope.markAsLegacy();
            }
        }
        return envelope;
    }

    public void addItem(Item item) {
        if (this.isSigned()) {
            throw new IllegalStateException("Unable to set items, envelope is already signed.");
        }
        if (item instanceof Envelope) {
            throw new IllegalArgumentException("Not allowed to add an envelope to another envelope.");
        }
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
    }

    public void setItems(List<Item> items) {
        if (this.isSigned()) {
            throw new IllegalStateException("Unable to set items, envelope is already signed.");
        }
        this.items = new ArrayList<Item>(items);
    }

    public Item getItem(String context) {
        if (context == null || this.items == null || this.items.size() == 0) {
            return null;
        }
        for (Item item : this.items) {
            String ctx = (String)item.getClaim(Claim.CTX);
            if (ctx == null || !ctx.equalsIgnoreCase(context)) continue;
            return item;
        }
        return null;
    }

    public Item getItem(UUID uniqueId) {
        if (uniqueId == null || this.items == null || this.items.size() == 0) {
            return null;
        }
        for (Item item : this.items) {
            if (!item.getClaim(Claim.UID).equals(uniqueId)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void sign(Key key) throws CryptographyException {
        if (this.isLegacy()) {
            if (this.isAnonymous()) {
                throw new IllegalStateException("Unable to sign, envelope is anonymous.");
            }
            if (this.isSigned()) {
                throw new IllegalStateException("Unable to sign, envelope is already signed.");
            }
        }
        if (this.items == null || this.items.isEmpty()) {
            throw new IllegalStateException("Unable to sign, at least one item must be attached before signing an envelope.");
        }
        super.sign(key);
    }

    @Override
    public IntegrityState verify(Key trustedKey, List<Item> linkedItems) {
        if (this.isLegacy() && this.isAnonymous()) {
            throw new IllegalStateException("Unable to verify, envelope is anonymous.");
        }
        return super.verify(trustedKey, linkedItems);
    }

    @Override
    public String exportToEncoded() {
        if (!this.isAnonymous() && !this.isSigned()) {
            throw new IllegalStateException("Unable to export, envelope is not signed.");
        }
        try {
            return this.encoded(this.isSigned());
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    @Override
    public String thumbprint() throws CryptographyException {
        try {
            return Envelope.thumbprint(this.encoded(!this.isAnonymous()));
        }
        catch (InvalidFormatException e) {
            throw new CryptographyException("Unable to generate thumbprint for item, data invalid.");
        }
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected String encoded(boolean withSignature) throws InvalidFormatException {
        if (this.encoded == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(HEADER);
            if (!this.isAnonymous()) {
                builder.append(".");
                try {
                    builder.append(Utility.toBase64(this.exportClaims()));
                }
                catch (IOException e) {
                    throw new InvalidFormatException("Unexpected exception while encoding item: " + e);
                }
            }
            for (Item item : this.items) {
                builder.append(":");
                builder.append(item.forExport());
            }
            this.encoded = builder.toString();
        }
        if (withSignature && this.isSigned()) {
            return this.encoded + ":" + Signature.toEncoded(this.getSignatures());
        }
        return this.encoded;
    }

    @Override
    protected void customDecoding(List<String> components) {
    }
}

