/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Data;
import io.dimeformat.Dime;
import io.dimeformat.Key;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class Message
extends Data {
    public static final String HEADER = "MSG";
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.KID, Claim.MIM, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 4;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Key getPublicKey() {
        String pub = (String)this.getClaim(Claim.PUB);
        if (pub != null && pub.length() > 0) {
            try {
                return new Key(List.of(KeyCapability.EXCHANGE), pub, Claim.PUB);
            }
            catch (CryptographyException cryptographyException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPublicKey(Key publicKey) {
        if (publicKey != null) {
            this.throwIfSigned();
            this.setClaimValue(Claim.PUB, publicKey.getPublic());
        } else {
            this.removeClaim(Claim.PUB);
        }
    }

    public Message(UUID issuerId) {
        this(null, issuerId, -1L, null);
    }

    public Message(UUID issuerId, long validFor) {
        this(null, issuerId, validFor, null);
    }

    public Message(UUID audienceId, UUID issuerId) {
        this(audienceId, issuerId, -1L, null);
    }

    public Message(UUID audienceId, UUID issuerId, long validFor) {
        this(audienceId, issuerId, validFor, null);
    }

    public Message(UUID audienceId, UUID issuerId, long validFor, String context) {
        if (context != null && context.length() > 84) {
            throw new IllegalArgumentException("Context must not be longer than 84.");
        }
        Instant iat = Utility.createTimestamp();
        Instant exp = validFor != -1L ? iat.plusSeconds(validFor) : null;
        this.setClaimValue(Claim.UID, UUID.randomUUID());
        this.setClaimValue(Claim.AUD, audienceId);
        this.setClaimValue(Claim.ISS, issuerId);
        this.setClaimValue(Claim.IAT, iat);
        this.setClaimValue(Claim.EXP, exp);
        this.setClaimValue(Claim.CTX, context);
    }

    @Override
    public String thumbprint() throws CryptographyException {
        if (!this.isSigned()) {
            throw new IllegalStateException("Unable to generate thumbprint, must be signed first.");
        }
        return super.thumbprint();
    }

    public void setPayload(byte[] payload, Key issuerKey, Key audienceKey) throws CryptographyException {
        this.throwIfSigned();
        if (payload == null || payload.length == 0) {
            throw new IllegalArgumentException("Unable to set payload, payload must not be null or empty.");
        }
        if (issuerKey == null) {
            throw new IllegalArgumentException("Unable to encrypt, issuer key must not be null.");
        }
        if (audienceKey == null) {
            throw new IllegalArgumentException("Unable to encrypt, audience key must not be null.");
        }
        Key sharedKey = issuerKey.generateSharedSecret(audienceKey, List.of(KeyCapability.ENCRYPT));
        this.setPayload(Dime.crypto.encrypt(payload, sharedKey));
    }

    public byte[] getPayload(Key issuerKey, Key audienceKey) throws CryptographyException {
        if (issuerKey == null) {
            throw new IllegalArgumentException("Provided issuer key may not be null.");
        }
        if (audienceKey == null) {
            throw new IllegalArgumentException("Provided audience key may not be null.");
        }
        Key sharedKey = issuerKey.generateSharedSecret(audienceKey, List.of(KeyCapability.ENCRYPT));
        return Dime.crypto.decrypt(this.getPayload(), sharedKey);
    }

    Message() {
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected String forExport() throws InvalidFormatException {
        if (!this.isSigned()) {
            throw new IllegalStateException("Unable to encode message, must be signed first.");
        }
        return super.forExport();
    }

    @Override
    protected void customDecoding(List<String> components) throws InvalidFormatException {
        super.customDecoding(components);
        this.isSigned = true;
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 4;
    }
}

