/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.crypto;

import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import java.util.List;

public interface ICryptoSuite {
    public static final int SECRET_KEY_INDEX = 0;
    public static final int PUBLIC_KEY_INDEX = 1;

    public String getName();

    public byte[] generateKeyName(byte[][] var1);

    public byte[] generateSignature(byte[] var1, byte[] var2) throws CryptographyException;

    public boolean verifySignature(byte[] var1, byte[] var2, byte[] var3);

    public byte[][] generateKey(List<KeyCapability> var1) throws CryptographyException;

    public byte[] generateSharedSecret(byte[][] var1, byte[][] var2, List<KeyCapability> var3) throws CryptographyException;

    public byte[] encrypt(byte[] var1, byte[] var2) throws CryptographyException;

    public byte[] decrypt(byte[] var1, byte[] var2) throws CryptographyException;

    public byte[] generateHash(byte[] var1) throws CryptographyException;
}

