/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.crypto;

import com.goterl.lazysodium.SodiumJava;
import io.dimeformat.Utility;
import io.dimeformat.crypto.ICryptoSuite;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import java.util.List;

class StandardSuite
implements ICryptoSuite {
    static final String NAME = "STN";
    private static final int NBR_SIGNATURE_BYTES = 64;
    private static final int NBR_A_KEY_BYTES = 32;
    private static final int NBR_S_KEY_BYTES = 32;
    private static final int NBR_X_KEY_BYTES = 32;
    private static final int NBR_NONCE_BYTES = 24;
    private static final int NBR_MAC_BYTES = 16;
    private static final int NBR_HASH_BYTES = 32;
    private final SodiumJava sodium = new SodiumJava();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] generateKeyName(byte[][] key) {
        byte[] identifier = null;
        byte[] bytes = key[1];
        if (bytes != null && bytes.length > 0) {
            try {
                byte[] hash = this.generateHash(bytes);
                identifier = Utility.subArray(hash, 0, 8);
            }
            catch (CryptographyException cryptographyException) {
                // empty catch block
            }
        }
        return identifier;
    }

    @Override
    public byte[] generateSignature(byte[] data, byte[] key) throws CryptographyException {
        byte[] signature = new byte[64];
        if (this.sodium.crypto_sign_detached(signature, null, data, (long)data.length, key) != 0) {
            throw new CryptographyException("Cryptographic operation failed.");
        }
        return signature;
    }

    @Override
    public boolean verifySignature(byte[] data, byte[] signature, byte[] key) {
        return this.sodium.crypto_sign_verify_detached(signature, data, (long)data.length, key) == 0;
    }

    @Override
    public byte[][] generateKey(List<KeyCapability> capabilities) throws CryptographyException {
        byte[] secretKey;
        if (capabilities == null || capabilities.size() != 1) {
            throw new IllegalArgumentException("Unable to generate, invalid key capabilities requested.");
        }
        KeyCapability firstUse = capabilities.get(0);
        if (firstUse == KeyCapability.ENCRYPT) {
            byte[] secretKey2 = new byte[32];
            this.sodium.crypto_secretbox_keygen(secretKey2);
            return new byte[][]{secretKey2};
        }
        byte[] publicKey = new byte[32];
        switch (capabilities.get(0)) {
            case SIGN: {
                secretKey = new byte[64];
                this.sodium.crypto_sign_keypair(publicKey, secretKey);
                break;
            }
            case EXCHANGE: {
                secretKey = new byte[32];
                this.sodium.crypto_kx_keypair(publicKey, secretKey);
                break;
            }
            default: {
                throw new CryptographyException("Unable to generate keypair for key type " + capabilities + ".");
            }
        }
        return new byte[][]{secretKey, publicKey};
    }

    @Override
    public byte[] generateSharedSecret(byte[][] clientKey, byte[][] serverKey, List<KeyCapability> capabilities) throws CryptographyException {
        if (!capabilities.contains((Object)KeyCapability.ENCRYPT)) {
            throw new IllegalArgumentException("Unable to generate, key capability for shared secret must be ENCRYPT.");
        }
        if (capabilities.size() > 1) {
            throw new IllegalArgumentException("Unable to generate, key capability for shared secret may only be ENCRYPT.");
        }
        byte[] shared = new byte[32];
        if (clientKey[0] != null && clientKey.length == 2) {
            byte[] secret = Utility.combine(clientKey[0], clientKey[1]);
            if (this.sodium.crypto_kx_client_session_keys(shared, null, clientKey[1], secret, serverKey[1]) != 0) {
                throw new CryptographyException("Unable to generate, cryptographic operation failed.");
            }
        } else if (serverKey[0] != null && serverKey.length == 2) {
            if (this.sodium.crypto_kx_server_session_keys(null, shared, serverKey[1], serverKey[0], clientKey[1]) != 0) {
                throw new CryptographyException("Unable to generate, cryptographic operation failed.");
            }
        } else {
            throw new CryptographyException("Unable to generate, invalid keys provided.");
        }
        return shared;
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key) throws CryptographyException {
        byte[] nonce = Utility.randomBytes(24);
        if (nonce.length > 0) {
            byte[] cipherText = new byte[16 + data.length];
            if (this.sodium.crypto_secretbox_easy(cipherText, data, (long)data.length, nonce, key) != 0) {
                throw new CryptographyException("Cryptographic operation failed.");
            }
            return Utility.combine(nonce, cipherText);
        }
        throw new CryptographyException("Unable to generate sufficient nonce.");
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] key) throws CryptographyException {
        byte[] nonce = Utility.subArray(data, 0, 24);
        byte[] bytes = Utility.subArray(data, 24);
        byte[] plain = new byte[bytes.length - 16];
        int result = this.sodium.crypto_secretbox_open_easy(plain, bytes, (long)bytes.length, nonce, key);
        if (result != 0) {
            throw new CryptographyException("Cryptographic operation failed (" + result + ").");
        }
        return plain;
    }

    @Override
    public byte[] generateHash(byte[] data) throws CryptographyException {
        byte[] hash = new byte[32];
        if (this.sodium.crypto_generichash(hash, hash.length, data, (long)data.length, null, 0) != 0) {
            throw new CryptographyException("Cryptographic operation failed.");
        }
        return hash;
    }
}

