/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.keyring;

import io.dimeformat.Dime;
import io.dimeformat.Envelope;
import io.dimeformat.Identity;
import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.IntegrityStateException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public class KeyRing {
    private HashMap<String, Item> _keyRing;

    public int size() {
        return this._keyRing != null ? this._keyRing.size() : 0;
    }

    public boolean isEmpty() {
        return this._keyRing == null || this._keyRing.isEmpty();
    }

    public boolean containsName(String name) {
        return this._keyRing != null && this._keyRing.containsKey(name);
    }

    public boolean containsItem(Item item) {
        String name;
        if (item instanceof Key) {
            String name2 = Dime.crypto.generateKeyName((Key)item);
            if (this._keyRing.containsKey(name2)) {
                Key key = (Key)this._keyRing.get(name2);
                return key.getPublic().equals(((Key)item).getPublic());
            }
        } else if (item instanceof Identity && this._keyRing.containsKey(name = ((Identity)item).getClaim(Claim.SUB).toString().toLowerCase())) {
            Identity identity = (Identity)this._keyRing.get(name);
            return ((UUID)identity.getClaim(Claim.SUB)).compareTo((UUID)item.getClaim(Claim.SUB)) == 0 && identity.getPublicKey().getPublic().equals(((Identity)item).getPublicKey().getPublic());
        }
        return false;
    }

    public Item get(String name) {
        return this._keyRing != null ? this._keyRing.get(name) : null;
    }

    public void put(Key key) {
        this.put(Dime.crypto.generateKeyName(key), key);
    }

    public void put(Identity identity) {
        this.put(identity.getClaim(Claim.SUB).toString().toLowerCase(), identity);
    }

    public Key remove(Key key) {
        String name = Dime.crypto.generateKeyName(key);
        return (Key)this.remove(name);
    }

    public Identity remove(Identity identity) {
        return (Identity)this.remove(identity.getClaim(Claim.SUB).toString().toLowerCase());
    }

    public Item remove(String name) {
        return this._keyRing != null ? this._keyRing.remove(name) : null;
    }

    public void clear() {
        if (this._keyRing != null) {
            this._keyRing.clear();
        }
    }

    public Set<String> nameSet() {
        return this._keyRing != null ? this._keyRing.keySet() : null;
    }

    public Collection<Item> items() {
        return this._keyRing != null ? this._keyRing.values() : null;
    }

    public void importFromEncoded(String encoded, Key verifyKey) throws InvalidFormatException, IntegrityStateException {
        IntegrityState state;
        Envelope envelope = Envelope.importFromEncoded(encoded);
        if (verifyKey != null && !(state = envelope.verify(verifyKey)).isValid()) {
            throw new IntegrityStateException(state, "Unable to import key ring, unable to verify integrity.");
        }
        for (Item item : envelope.getItems()) {
            if (item instanceof Key) {
                this.put((Key)item);
                continue;
            }
            if (item instanceof Identity) {
                this.put((Identity)item);
                continue;
            }
            throw new IllegalArgumentException("Unable to import key ring, encoded envelope must only contain keys and identities.");
        }
    }

    public String exportToEncoded(Key signingKey) throws CryptographyException {
        if (this._keyRing != null && !this._keyRing.isEmpty()) {
            Envelope envelope = new Envelope();
            for (String name : this.nameSet()) {
                envelope.addItem(this.get(name));
            }
            if (signingKey != null) {
                envelope.sign(signingKey);
            }
            return envelope.exportToEncoded();
        }
        return null;
    }

    private void put(String name, Item item) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Unable to add to key ring, name must not be null or empty.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Unable to add to key ring, item to add must not be null.");
        }
        if (item instanceof Key || item instanceof Identity) {
            if (this._keyRing == null) {
                this._keyRing = new HashMap();
            }
            this._keyRing.put(name, item);
            return;
        }
        throw new IllegalArgumentException("Unable to add to key ring, item to add must either be an instance of Key or Identity.");
    }
}

