/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.IdentityCapability;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class Identity
extends Item {
    public static final String HEADER = "ID";
    private Key _publicKey;
    private List<IdentityCapability> _capabilities;
    private Map<String, Object> _principles;
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CMN, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.ISU, Claim.KID, Claim.MTD, Claim.PRI, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 3;
    private static final int MAXIMUM_NBR_COMPONENTS = 4;
    private static final int COMPONENTS_CHAIN_INDEX = 2;
    private Identity trustChain;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Key getPublicKey() {
        if (this._publicKey == null) {
            try {
                this._publicKey = new Key(List.of(KeyCapability.SIGN), (String)this.getClaim(Claim.PUB), Claim.PUB);
            }
            catch (CryptographyException e) {
                return null;
            }
        }
        return this._publicKey;
    }

    public List<IdentityCapability> getCapabilities() {
        if (this._capabilities == null) {
            List caps = (List)this.getClaim(Claim.CAP);
            this._capabilities = caps.stream().map(IdentityCapability::fromString).collect(Collectors.toList());
        }
        return this._capabilities;
    }

    public Map<String, Object> getPrinciples() {
        Map pri;
        if (this._principles == null && (pri = (Map)this.getClaim(Claim.PRI)) != null) {
            this._principles = Collections.unmodifiableMap(pri);
        }
        return this._principles;
    }

    public Identity getTrustChain() {
        return this.trustChain;
    }

    public boolean isSelfIssued() {
        return ((UUID)this.getClaim(Claim.SUB)).compareTo((UUID)this.getClaim(Claim.ISS)) == 0 && this.hasCapability(IdentityCapability.SELF);
    }

    @Override
    public IntegrityState verify(Identity trustedIdentity, List<Item> linkedItems) {
        IntegrityState state = IntegrityState.FAILED_NOT_TRUSTED;
        Identity trustChain = this.getTrustChain();
        if (trustChain != null) {
            state = super.verify(trustChain, null);
            if (state.isValid()) {
                if (!trustChain.getClaim(Claim.SUB).equals(trustedIdentity.getClaim(Claim.SUB))) {
                    state = trustChain.verify(trustedIdentity, null);
                } else {
                    if (trustedIdentity.isSelfIssued()) {
                        return trustedIdentity.verify(trustedIdentity.getPublicKey());
                    }
                    state = trustedIdentity.verifyDates();
                    return !state.isValid() ? state : IntegrityState.INTACT;
                }
            }
            if (state.isValid() && linkedItems != null) {
                state = this.verifyLinkedItems(linkedItems);
            }
        } else {
            state = super.verify(trustedIdentity, linkedItems);
        }
        return state;
    }

    @Override
    public IntegrityState verify(Key verifyKey, List<Item> linkedItems) {
        Identity trustChain = this.getTrustChain();
        if (trustChain == null || verifyKey != null) {
            return super.verify(verifyKey, linkedItems);
        }
        IntegrityState state = trustChain.verify();
        return !state.isValid() ? state : super.verify(trustChain.getPublicKey(), linkedItems);
    }

    public boolean hasCapability(IdentityCapability capability) {
        return this.getCapabilities().contains((Object)capability);
    }

    @Override
    public void convertToLegacy() {
        if (this.isLegacy()) {
            return;
        }
        super.convertToLegacy();
        Key.convertKeyToLegacy(this, KeyCapability.SIGN, Claim.PUB);
    }

    public void sign(Identity issuer, Key key, boolean includeChain) throws CryptographyException {
        if (includeChain) {
            this.setTrustChain(issuer);
        }
        super.sign(key);
    }

    Identity() {
    }

    Identity(String systemName, UUID subjectId, Key subjectKey, Instant issuedAt, Instant expiresAt, UUID issuerId, List<String> capabilities, Map<String, Object> principles, List<String> ambitList, List<String> methods) {
        if (systemName == null || systemName.length() == 0) {
            throw new IllegalArgumentException("System name must not be null or empty.");
        }
        this.setClaimValue(Claim.UID, UUID.randomUUID());
        this.setClaimValue(Claim.SYS, systemName);
        this.setClaimValue(Claim.SUB, subjectId);
        this.setClaimValue(Claim.ISS, issuerId);
        this.setClaimValue(Claim.IAT, issuedAt);
        this.setClaimValue(Claim.EXP, expiresAt);
        this.setClaimValue(Claim.PUB, subjectKey.getPublic());
        this.setClaimValue(Claim.CAP, capabilities);
        this.setClaimValue(Claim.PRI, principles);
        this.setClaimValue(Claim.AMB, ambitList);
        this.setClaimValue(Claim.MTD, methods);
    }

    void setTrustChain(Identity trustChain) {
        this.trustChain = trustChain;
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected void customDecoding(List<String> components) throws InvalidFormatException {
        if (components.size() > 4) {
            throw new InvalidFormatException("More components in item than expected, got " + components.size() + ", expected maximum 4");
        }
        if (components.size() == 4) {
            byte[] issuer = Utility.fromBase64(components.get(2));
            this.trustChain = Identity.fromEncodedIdentity(new String(issuer, StandardCharsets.UTF_8));
        }
        this.isSigned = true;
    }

    @Override
    protected void customEncoding(StringBuilder builder) throws InvalidFormatException {
        super.customEncoding(builder);
        if (this.trustChain != null) {
            builder.append(".");
            builder.append(Utility.toBase64(this.trustChain.forExport()));
        }
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 3;
    }

    private static Identity fromEncodedIdentity(String encoded) throws InvalidFormatException {
        Identity identity = new Identity();
        identity.decode(encoded);
        return identity;
    }
}

