/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Base58;
import io.dimeformat.Dime;
import io.dimeformat.Item;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class Key
extends Item {
    public static final String HEADER = "KEY";
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CMN, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.ISU, Claim.KID, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int CRYPTO_SUITE_INDEX = 0;
    private static final int ENCODED_KEY_INDEX = 1;
    private static final int LEGACY_KEY_HEADER_SIZE = 6;
    private String _suiteName;
    private List<KeyCapability> _capabilities;
    private byte[] _secretBytes;
    private byte[] _publicBytes;

    public Key(List<KeyCapability> capabilities, byte[] rawKey, byte[] rawPub, String suiteName) {
        this(UUID.randomUUID(), capabilities, rawKey, rawPub, suiteName);
    }

    @Override
    public String getHeader() {
        return HEADER;
    }

    public String getCryptoSuiteName() {
        if (this._suiteName == null && this.getKeyBytes(Claim.KEY) == null) {
            this.getKeyBytes(Claim.PUB);
        }
        return this._suiteName;
    }

    public String getSecret() {
        return (String)this.getClaim(Claim.KEY);
    }

    public String getPublic() {
        return (String)this.getClaim(Claim.PUB);
    }

    public byte[] getKeyBytes(Claim claim) {
        try {
            if (claim == Claim.KEY) {
                if (this._secretBytes == null) {
                    this.decodeKey((String)this.getClaim(Claim.KEY), Claim.KEY);
                }
                return this._secretBytes;
            }
            if (claim == Claim.PUB) {
                if (this._publicBytes == null) {
                    this.decodeKey((String)this.getClaim(Claim.PUB), Claim.PUB);
                }
                return this._publicBytes;
            }
            throw new IllegalArgumentException("Invalid claim for key provided: " + claim);
        }
        catch (CryptographyException ignored) {
            return null;
        }
    }

    public String getName() {
        return Dime.crypto.generateKeyName(this);
    }

    public List<KeyCapability> getCapability() {
        if (this._capabilities == null) {
            List caps = (List)this.getClaim(Claim.CAP);
            if (caps != null) {
                this._capabilities = caps.stream().map(cap -> KeyCapability.valueOf(cap.toUpperCase())).collect(Collectors.toList());
            } else {
                this.getKeyBytes(Claim.PUB);
                this.getKeyBytes(Claim.KEY);
            }
        }
        return this._capabilities;
    }

    public boolean hasCapability(KeyCapability capability) {
        if (capability == null) {
            return false;
        }
        return this.getCapability().contains((Object)capability);
    }

    public static Key generateKey(KeyCapability capability) {
        return Key.generateKey(List.of(capability), -1L, null, null, Dime.crypto.getDefaultSuiteName());
    }

    public static Key generateKey(List<KeyCapability> capabilities) {
        return Key.generateKey(capabilities, -1L, null, null, Dime.crypto.getDefaultSuiteName());
    }

    public static Key generateKey(List<KeyCapability> capabilities, String context) {
        return Key.generateKey(capabilities, -1L, null, context, Dime.crypto.getDefaultSuiteName());
    }

    public static Key generateKey(List<KeyCapability> capabilities, long validFor, UUID issuerId, String context) {
        return Key.generateKey(capabilities, validFor, issuerId, context, Dime.crypto.getDefaultSuiteName());
    }

    public static Key generateKey(List<KeyCapability> capabilities, long validFor, UUID issuerId, String context, String suiteName) {
        try {
            if (context != null && context.length() > 84) {
                throw new IllegalArgumentException("Context must not be longer than 84.");
            }
            Key key = Dime.crypto.generateKey(capabilities, suiteName);
            if (validFor != -1L) {
                key.setClaimValue(Claim.EXP, ((Instant)key.getClaim(Claim.IAT)).plusSeconds(validFor));
            }
            key.setClaimValue(Claim.ISS, issuerId);
            key.setClaimValue(Claim.CTX, context);
            return key;
        }
        catch (CryptographyException e) {
            throw new RuntimeException("Unexpected exception thrown when generating key: " + e);
        }
    }

    public Key publicCopy() {
        Key copyKey = new Key(this.getCapability(), null, this.getPublic(), this.getCryptoSuiteName());
        copyKey.setClaimValue(Claim.UID, this.getClaim(Claim.UID));
        copyKey.setClaimValue(Claim.IAT, this.getClaim(Claim.IAT));
        copyKey.setClaimValue(Claim.EXP, this.getClaim(Claim.EXP));
        copyKey.setClaimValue(Claim.ISS, this.getClaim(Claim.ISS));
        copyKey.setClaimValue(Claim.CTX, this.getClaim(Claim.CTX));
        copyKey.setClaimValue(Claim.CAP, this.getCapability().stream().map(aUse -> aUse.name().toLowerCase()).collect(Collectors.toList()));
        return copyKey;
    }

    public Key generateSharedSecret(Key key, List<KeyCapability> capabilities) throws CryptographyException {
        return Dime.crypto.generateSharedSecret(this, key, capabilities);
    }

    @Override
    public void convertToLegacy() {
        if (this.isLegacy()) {
            return;
        }
        Key.convertKeyToLegacy(this, this.getCapability().get(0), Claim.KEY);
        Key.convertKeyToLegacy(this, this.getCapability().get(0), Claim.PUB);
        super.convertToLegacy();
    }

    @Override
    public boolean isLegacy() {
        this.getKeyBytes(Claim.PUB);
        this.getKeyBytes(Claim.KEY);
        return super.isLegacy();
    }

    Key() {
    }

    Key(UUID id, List<KeyCapability> capabilities, byte[] rawKey, byte[] rawPub, String suiteName) {
        this.setClaimValue(Claim.UID, id);
        this.setClaimValue(Claim.IAT, Utility.createTimestamp());
        this._suiteName = suiteName != null ? suiteName : Dime.crypto.getDefaultSuiteName();
        this._capabilities = capabilities;
        this.setClaimValue(Claim.CAP, capabilities.stream().map(aUse -> aUse.name().toLowerCase()).collect(Collectors.toList()));
        if (rawKey != null) {
            this.setClaimValue(Claim.KEY, Key.packageKey(suiteName, Dime.crypto.encodeKeyBytes(rawKey, Claim.KEY, this._suiteName)));
        }
        if (rawPub != null) {
            this.setClaimValue(Claim.PUB, Key.packageKey(suiteName, Dime.crypto.encodeKeyBytes(rawPub, Claim.PUB, this._suiteName)));
        }
    }

    Key(List<KeyCapability> capabilities, String key, String pub, String suiteName) {
        this._suiteName = suiteName;
        this._capabilities = capabilities;
        if (key != null) {
            this.setClaimValue(Claim.KEY, key);
        }
        if (pub != null) {
            this.setClaimValue(Claim.PUB, pub);
        }
    }

    Key(List<KeyCapability> capabilities, String key, Claim claim) throws CryptographyException {
        this._capabilities = capabilities;
        this.setClaimValue(claim, key);
    }

    @Deprecated
    static void convertKeyToLegacy(Item item, KeyCapability capability, Claim claim) {
        String key = (String)item.getClaim(claim);
        if (key == null) {
            return;
        }
        byte[] header = new byte[]{1, 0, 0, 0, 0, 0};
        String[] components = key.split("\\.");
        if (components.length == 1) {
            return;
        }
        byte[] rawKey = Dime.crypto.decodeKeyBytes(components[1], claim, components[0]);
        byte[] legacyKey = Utility.combine(header, rawKey);
        legacyKey[1] = capability == KeyCapability.ENCRYPT ? 16 : (capability == KeyCapability.EXCHANGE ? 64 : -128);
        int n = legacyKey[2] = capability == KeyCapability.EXCHANGE ? 2 : 1;
        if (claim == Claim.PUB) {
            legacyKey[3] = 1;
        } else if (capability == KeyCapability.ENCRYPT) {
            legacyKey[3] = 2;
        }
        item.setClaimValue(claim, Base58.encode(legacyKey));
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected void customDecoding(List<String> components) throws InvalidFormatException {
        if (components.size() > 3) {
            throw new InvalidFormatException("More components in item than expected, got " + components.size() + ", expected maximum 3");
        }
        this.isSigned = components.size() > 2;
    }

    @Deprecated
    private static KeyCapability getCapabilityFromLegacy(byte[] key) {
        switch (key[1]) {
            case 16: {
                return KeyCapability.keyCapabilityFromLegacy("encryption");
            }
            case 64: {
                return KeyCapability.keyCapabilityFromLegacy("exchange");
            }
            case -128: {
                return KeyCapability.keyCapabilityFromLegacy("identity");
            }
            case -32: {
                return KeyCapability.keyCapabilityFromLegacy("authenticate");
            }
        }
        return null;
    }

    private static String packageKey(String suiteName, String encodedKey) {
        return suiteName + "." + encodedKey;
    }

    private void decodeKey(String encoded, Claim claim) throws CryptographyException {
        byte[] rawKey;
        String suiteName;
        if (encoded == null || encoded.isEmpty()) {
            return;
        }
        String[] components = encoded.split("\\.");
        boolean legacyKey = false;
        if (components.length == 2) {
            suiteName = components[0];
        } else {
            suiteName = "STN";
            legacyKey = true;
            this.markAsLegacy();
        }
        if (this._suiteName == null) {
            this._suiteName = suiteName;
        } else if (!this._suiteName.equals(suiteName)) {
            String otherKeyPart;
            String string = otherKeyPart = claim == Claim.KEY ? (String)this.getClaim(Claim.PUB) : (String)this.getClaim(Claim.KEY);
            if (otherKeyPart != null) {
                throw new CryptographyException("Public and secret keys generated using different cryptographic suites: " + this._suiteName + " and " + suiteName + ".");
            }
        }
        if (!legacyKey) {
            rawKey = Dime.crypto.decodeKeyBytes(components[1], claim, suiteName);
        } else {
            byte[] decoded = Dime.crypto.decodeKeyBytes(encoded, claim, suiteName);
            rawKey = Utility.subArray(decoded, 6);
            KeyCapability cap = Key.getCapabilityFromLegacy(decoded);
            if (cap == null) {
                throw new IllegalStateException("Invalid key capability encountered.");
            }
            this._capabilities = List.of(cap);
        }
        if (claim == Claim.KEY) {
            this._secretBytes = rawKey;
        } else if (claim == Claim.PUB) {
            this._publicBytes = rawKey;
        } else {
            throw new IllegalArgumentException("Invalid claim provided for key: " + claim);
        }
        if (legacyKey) {
            this.markAsLegacy();
        }
    }
}

