/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Data;
import io.dimeformat.Dime;
import io.dimeformat.Key;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class Message
extends Data {
    public static final String HEADER = "MSG";
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CMN, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.ISU, Claim.KID, Claim.MIM, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 4;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Key getPublicKey() {
        String pub = (String)this.getClaim(Claim.PUB);
        if (pub != null && !pub.isEmpty()) {
            try {
                return new Key(List.of(KeyCapability.EXCHANGE), pub, Claim.PUB);
            }
            catch (CryptographyException cryptographyException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPublicKey(Key publicKey) {
        if (publicKey != null) {
            this.throwIfSigned();
            this.setClaimValue(Claim.PUB, publicKey.getPublic());
        } else {
            this.removeClaim(Claim.PUB);
        }
    }

    public Message(UUID issuerId) {
        this(null, issuerId, -1L, null);
    }

    public Message(UUID issuerId, long validFor) {
        this(null, issuerId, validFor, null);
    }

    public Message(UUID audienceId, UUID issuerId) {
        this(audienceId, issuerId, -1L, null);
    }

    public Message(UUID audienceId, UUID issuerId, long validFor) {
        this(audienceId, issuerId, validFor, null);
    }

    public Message(UUID audienceId, UUID issuerId, long validFor, String context) {
        if (context != null && context.length() > 84) {
            throw new IllegalArgumentException("Context must not be longer than 84.");
        }
        Instant iat = Utility.createTimestamp();
        Instant exp = validFor != -1L ? iat.plusSeconds(validFor) : null;
        this.setClaimValue(Claim.UID, UUID.randomUUID());
        this.setClaimValue(Claim.AUD, audienceId);
        this.setClaimValue(Claim.ISS, issuerId);
        this.setClaimValue(Claim.IAT, iat);
        this.setClaimValue(Claim.EXP, exp);
        this.setClaimValue(Claim.CTX, context);
    }

    public void setPayload(byte[] payload, Key firstKey, Key secondKey) throws CryptographyException {
        this.throwIfSigned();
        if (payload == null || payload.length == 0) {
            throw new IllegalArgumentException("Unable to set payload, payload must not be null or empty.");
        }
        if (firstKey == null || secondKey == null) {
            throw new IllegalArgumentException("Unable to set payload, both keys must be of a non-null value.");
        }
        if (firstKey.getSecret() != null && secondKey.getSecret() != null) {
            throw new IllegalArgumentException("Unable to set payload, both keys must not contain a secret (private) key.");
        }
        Key primaryKey = firstKey.getSecret() != null ? firstKey : secondKey;
        Key secondaryKey = secondKey.getSecret() == null ? secondKey : firstKey;
        Key sharedKey = primaryKey.generateSharedSecret(secondaryKey, List.of(KeyCapability.ENCRYPT));
        this.setPayload(Dime.crypto.encrypt(payload, sharedKey));
    }

    public Key setPayload(byte[] payload, Key key) throws CryptographyException {
        if (key == null) {
            throw new NullPointerException("Unable to set payload, key must not be null");
        }
        if (key.hasCapability(KeyCapability.EXCHANGE)) {
            if (key.getSecret() != null) {
                throw new IllegalArgumentException("Unable to set payload, key should not contain a secret (or private) key.");
            }
            Key firstKey = Key.generateKey(KeyCapability.EXCHANGE);
            this.setPayload(payload, firstKey, key);
            this.setPublicKey(firstKey.publicCopy());
            return firstKey;
        }
        if (key.hasCapability(KeyCapability.ENCRYPT)) {
            this.setPayload(Dime.crypto.encrypt(payload, key));
            this.putClaim(Claim.KID, key.getClaim(Claim.UID));
            return key;
        }
        throw new CryptographyException("Key capability mismatch.");
    }

    public byte[] getPayload(Key firstKey, Key secondKey) throws CryptographyException {
        if (firstKey == null || secondKey == null) {
            throw new IllegalArgumentException("Unable to get payload, both keys must be of a non-null value.");
        }
        if (firstKey.getSecret() != null && secondKey.getSecret() != null) {
            throw new IllegalArgumentException("Unable to get payload, both keys must not contain a secret (private) key.");
        }
        Key primaryKey = firstKey.getSecret() != null ? firstKey : secondKey;
        Key secondaryKey = secondKey.getSecret() == null ? secondKey : firstKey;
        try {
            Key sharedKey = secondaryKey.generateSharedSecret(primaryKey, List.of(KeyCapability.ENCRYPT));
            return Dime.crypto.decrypt(this.getPayload(), sharedKey);
        }
        catch (CryptographyException sharedKey) {
            Key sharedKey2 = primaryKey.generateSharedSecret(secondaryKey, List.of(KeyCapability.ENCRYPT));
            return Dime.crypto.decrypt(this.getPayload(), sharedKey2);
        }
    }

    public byte[] getPayload(Key key) throws CryptographyException {
        if (key == null) {
            throw new NullPointerException("Unable to get payload, key must not be null");
        }
        if (key.hasCapability(KeyCapability.EXCHANGE)) {
            if (this.getClaim(Claim.PUB) == null) {
                throw new IllegalStateException("Unable to get payload, no public key attached to message.");
            }
            return this.getPayload(this.getPublicKey(), key);
        }
        if (key.hasCapability(KeyCapability.ENCRYPT)) {
            return Dime.crypto.decrypt(this.getPayload(), key);
        }
        throw new CryptographyException("Key capability mismatch.");
    }

    Message() {
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected String forExport() throws InvalidFormatException {
        if (!this.isSigned()) {
            throw new IllegalStateException("Unable to encode message, must be signed first.");
        }
        return super.forExport();
    }

    @Override
    protected void customDecoding(List<String> components) throws InvalidFormatException {
        super.customDecoding(components);
        this.isSigned = true;
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 4;
    }
}

