/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Utility;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Signature {
    final byte[] bytes;
    final String name;
    private static final int INDEX_KEY_NAME = 0;
    private static final int INDEX_SIGNATURE = 1;

    public Signature(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLegacy() {
        return this.name == null;
    }

    public static List<Signature> fromEncoded(String encoded) {
        String[] items;
        if (encoded == null || encoded.isEmpty()) {
            throw new IllegalArgumentException("Encoded list of signatures must not be null or empty.");
        }
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        String decoded = new String(Utility.fromBase64(encoded), StandardCharsets.UTF_8);
        for (String combined : items = decoded.split(":")) {
            String[] components = combined.split("\\.");
            if (components.length == 1) {
                signatures.add(new Signature(Utility.fromBase64(encoded), null));
                break;
            }
            try {
                signatures.add(new Signature(Utility.fromHex(components[1]), components[0]));
            }
            catch (Exception e) {
                signatures.add(new Signature(Utility.fromBase64(encoded), null));
                break;
            }
        }
        return signatures;
    }

    static String toEncoded(List<Signature> signatures) {
        StringBuilder builder = new StringBuilder();
        boolean isLegacy = signatures.get((int)0).name == null;
        for (Signature signature : signatures) {
            if (builder.length() > 0) {
                builder.append(":");
            }
            signature.toEncoded(builder);
        }
        return isLegacy ? builder.toString() : Utility.toBase64(builder.toString());
    }

    static Signature find(String name, List<Signature> signatures) {
        if (signatures == null) {
            return null;
        }
        return signatures.stream().filter(signature -> name.equals(signature.name)).findAny().orElse(null);
    }

    private void toEncoded(StringBuilder builder) {
        if (this.isLegacy()) {
            builder.append(Utility.toBase64(this.bytes));
        } else {
            builder.append(this.name);
            builder.append(".");
            builder.append(Utility.toHex(this.bytes));
        }
    }
}

