/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.crypto;

import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CryptographyException;
import java.util.List;

public interface ICryptoSuite {
    public String getName();

    public String generateKeyName(Key var1);

    public byte[] generateSignature(Item var1, Key var2) throws CryptographyException;

    public boolean verifySignature(Item var1, byte[] var2, Key var3) throws CryptographyException;

    public Key generateKey(List<KeyCapability> var1) throws CryptographyException;

    public Key generateSharedSecret(Key var1, Key var2, List<KeyCapability> var3) throws CryptographyException;

    public byte[] encrypt(byte[] var1, Key var2) throws CryptographyException;

    public byte[] decrypt(byte[] var1, Key var2) throws CryptographyException;

    public String generateHash(byte[] var1) throws CryptographyException;

    public String encodeKeyBytes(byte[] var1, Claim var2);

    public byte[] decodeKeyBytes(String var1, Claim var2);
}

