/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.keyring;

import io.dimeformat.Dime;
import io.dimeformat.Envelope;
import io.dimeformat.Identity;
import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.IntegrityStateException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public class KeyRing {
    private HashMap<String, Item> _keyRing;

    public int size() {
        return this._keyRing != null ? this._keyRing.size() : 0;
    }

    public boolean isEmpty() {
        return this._keyRing == null || this._keyRing.isEmpty();
    }

    public boolean containsName(String name) {
        return this._keyRing != null && this._keyRing.containsKey(name);
    }

    public boolean containsItem(Item item) {
        String name;
        if (this._keyRing == null) {
            return false;
        }
        if (item instanceof Key) {
            String name2 = Dime.crypto.generateKeyName((Key)item);
            if (this._keyRing.containsKey(name2)) {
                Key ringKey = (Key)this._keyRing.get(name2);
                return ringKey.getPublic().equals(((Key)item).getPublic());
            }
        } else if (item instanceof Identity && this._keyRing.containsKey(name = item.getClaim(Claim.SUB).toString().toLowerCase())) {
            Identity ringIdentity = (Identity)this._keyRing.get(name);
            return ((UUID)ringIdentity.getClaim(Claim.SUB)).compareTo((UUID)item.getClaim(Claim.SUB)) == 0 && ringIdentity.getPublicKey().getPublic().equals(((Identity)item).getPublicKey().getPublic());
        }
        return false;
    }

    public Item get(String name) {
        return this._keyRing != null ? this._keyRing.get(name) : null;
    }

    public String put(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Unable to add item to key ring, item to add must not be null.");
        }
        String name = KeyRing.itemName(item);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Unable to add item to key ring, invalid item.");
        }
        if (this._keyRing == null) {
            this._keyRing = new HashMap();
        }
        this._keyRing.put(name, item);
        return name;
    }

    public boolean remove(Item item) {
        return this.remove(KeyRing.itemName(item));
    }

    public boolean remove(String name) {
        if (this._keyRing != null && name != null && name.length() > 0) {
            return this._keyRing.remove(name) != null;
        }
        return false;
    }

    public void clear() {
        if (this._keyRing != null) {
            this._keyRing.clear();
        }
    }

    public Set<String> nameSet() {
        return this._keyRing != null ? this._keyRing.keySet() : null;
    }

    public Collection<Item> items() {
        return this._keyRing != null ? this._keyRing.values() : null;
    }

    public void importFromEncoded(String encoded, Key verifyKey) throws InvalidFormatException, IntegrityStateException {
        IntegrityState state;
        Envelope envelope = Envelope.importFromEncoded(encoded);
        if (verifyKey != null && !(state = envelope.verify(verifyKey)).isValid()) {
            throw new IntegrityStateException(state, "Unable to import key ring, unable to verify integrity.");
        }
        for (Item item : envelope.getItems()) {
            if (item instanceof Key) {
                this.put((Key)item);
                continue;
            }
            if (item instanceof Identity) {
                this.put((Identity)item);
                continue;
            }
            throw new IllegalArgumentException("Unable to import key ring, encoded envelope must only contain keys and identities.");
        }
    }

    public String exportToEncoded(Key signingKey) throws CryptographyException {
        if (this.isEmpty()) {
            return null;
        }
        Envelope envelope = new Envelope();
        for (String name : this.nameSet()) {
            envelope.addItem(this.get(name));
        }
        if (signingKey != null) {
            envelope.sign(signingKey);
        }
        return envelope.exportToEncoded();
    }

    public IntegrityState verify(Item item) {
        if (this.size() == 0) {
            return IntegrityState.FAILED_NO_KEY_RING;
        }
        IntegrityState state = IntegrityState.FAILED_NOT_TRUSTED;
        for (Item trustedItem : this.items()) {
            state = trustedItem.verifyDates();
            if (!state.isValid()) {
                return state;
            }
            Key trustedKey = KeyRing.getKey(trustedItem);
            if (trustedKey == null) {
                return IntegrityState.FAILED_INTERNAL_FAULT;
            }
            state = item.verifySignature(trustedKey);
            if (state == IntegrityState.FAILED_KEY_MISMATCH) continue;
            return state;
        }
        return state;
    }

    private static String itemName(Item item) {
        String name = null;
        if (item instanceof Key) {
            name = Dime.crypto.generateKeyName((Key)item);
        } else if (item instanceof Identity) {
            name = item.getClaim(Claim.SUB).toString().toLowerCase();
        }
        return name;
    }

    private static Key getKey(Item item) {
        if (item instanceof Key) {
            return (Key)item;
        }
        if (item instanceof Identity) {
            return ((Identity)item).getPublicKey();
        }
        return null;
    }
}

