/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.crypto.Crypto;
import io.dimeformat.keyring.KeyRing;
import java.time.Instant;

public final class Dime {
    public static final Crypto crypto = new Crypto();
    public static final KeyRing keyRing = new KeyRing();
    public static final int MAX_CONTEXT_LENGTH = 84;
    public static final String VERSION = "1.001";
    public static final long NO_EXPIRATION = -1L;
    public static final long VALID_FOR_1_MINUTE = 60L;
    public static final long VALID_FOR_1_HOUR = 3600L;
    public static final long VALID_FOR_1_DAY = 86400L;
    public static final long VALID_FOR_1_YEAR = 31536000L;
    static final String COMPONENT_DELIMITER = ".";
    static final String SECTION_DELIMITER = ":";
    private static long _gracePeriod = 0L;
    private static long _timeModifier = 0L;
    private static Instant _overrideTime = null;

    public static synchronized long getGracePeriod() {
        return _gracePeriod;
    }

    public static synchronized void setGracePeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("Unable to set grace period, must be a value of 0 or above.");
        }
        _gracePeriod = Math.abs(period);
    }

    public static synchronized long getTimeModifier() {
        return _timeModifier;
    }

    public static synchronized void setTimeModifier(long modifier) {
        _timeModifier = modifier;
    }

    public static synchronized void setOverrideTime(Instant time) {
        _overrideTime = time;
    }

    static Instant getTime() {
        if (_overrideTime != null) {
            return _overrideTime;
        }
        return Instant.now();
    }

    private Dime() {
        throw new IllegalStateException("Not intended to be instantiated.");
    }
}

