/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Dime;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;

public final class Utility {
    private static final char[] HEX_CHAR_SET = "0123456789abcdef".toCharArray();

    public static byte[] randomBytes(int length) {
        if (length <= 0) {
            return new byte[0];
        }
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHAR_SET[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHAR_SET[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] fromHex(String string) {
        int len = string.length();
        byte[] bytes = new byte[len >>> 1];
        for (int i = 0; i <= len - 2; i += 2) {
            bytes[i >>> 1] = (byte)(Integer.parseInt(string.substring(i, i + 2).trim(), 16) & 0xFF);
        }
        return bytes;
    }

    public static String toBase64(byte[] bytes) {
        return Base64.getEncoder().withoutPadding().encodeToString(bytes);
    }

    public static String toBase64(String string) {
        return Utility.toBase64(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] fromBase64(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static byte[] combine(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static byte[] subArray(byte[] array, int start, int length) {
        byte[] result = new byte[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    public static byte[] subArray(byte[] array, int start) {
        return Utility.subArray(array, start, array.length - start);
    }

    public static Instant createTimestamp() {
        Instant now = Dime.getTime();
        long modifier = Dime.getTimeModifier();
        if (modifier == 0L) {
            return now;
        }
        return now.plusSeconds(modifier);
    }

    public static int gracefulTimestampCompare(Instant baseTime, Instant otherTime) {
        Instant upper;
        int upperResult;
        if (baseTime == null || otherTime == null) {
            return 0;
        }
        long gracePeriod = Dime.getGracePeriod();
        if (gracePeriod == 0L) {
            return baseTime.compareTo(otherTime);
        }
        Instant lower = baseTime.minusSeconds(gracePeriod);
        int lowerResult = lower.compareTo(otherTime);
        return lowerResult == (upperResult = (upper = baseTime.plusSeconds(gracePeriod)).compareTo(otherTime)) ? lowerResult : 0;
    }

    private Utility() {
        throw new IllegalStateException("Not intended to be instantiated.");
    }
}

