/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Base58 {
    private static final int BASE_58 = 58;
    private static final int BASE_256 = 256;
    private static final int NBR_CHECKSUM_BYTES = 4;
    private static final char[] _indexTable = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final int[] _reverseTable = new int[128];

    public static String encode(byte[] data) {
        if (data != null && data.length > 0) {
            int length = data.length;
            byte[] bytes = new byte[length + 4];
            System.arraycopy(data, 0, bytes, 0, length);
            byte[] checksum = Base58.doubleHash(bytes, length);
            if (checksum.length > 0) {
                System.arraycopy(checksum, 0, bytes, length, 4);
                int start = 0;
                for (byte aByte : bytes) {
                    if (aByte != 0) break;
                    ++start;
                }
                StringBuilder builder = new StringBuilder();
                bytes = Arrays.copyOf(bytes, bytes.length);
                int index = start;
                while (index < bytes.length) {
                    builder.insert(0, _indexTable[Base58.calculateIndex(bytes, index, 256, 58)]);
                    if (bytes[index] != 0) continue;
                    ++index;
                }
                while (start > 0) {
                    builder.insert(0, '1');
                    --start;
                }
                return builder.toString();
            }
        }
        return null;
    }

    public static byte[] decode(String encoded) {
        byte[] actualChecksum;
        int start;
        if (encoded.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[encoded.length()];
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            int digit = c < '\u0080' ? _reverseTable[c] : -1;
            input58[i] = (byte)digit;
        }
        for (start = 0; start < input58.length && input58[start] == 0; ++start) {
        }
        byte[] decoded = new byte[encoded.length()];
        int position = decoded.length;
        int index = start;
        while (index < input58.length) {
            decoded[--position] = Base58.calculateIndex(input58, index, 58, 256);
            if (input58[index] != 0) continue;
            ++index;
        }
        while (position < decoded.length && decoded[position] == 0) {
            ++position;
        }
        byte[] result = Arrays.copyOfRange(decoded, position - start, decoded.length);
        byte[] data = Arrays.copyOfRange(result, 0, result.length - 4);
        byte[] checksum = Arrays.copyOfRange(result, result.length - 4, result.length);
        if (Arrays.equals(checksum, actualChecksum = Arrays.copyOfRange(Base58.doubleHash(data, data.length), 0, 4))) {
            return data;
        }
        return new byte[0];
    }

    private Base58() {
        throw new IllegalStateException("Not intended to be instantiated.");
    }

    private static byte calculateIndex(byte[] bytes, int position, int base, int divisor) {
        int remainder = 0;
        for (int i = position; i < bytes.length; ++i) {
            int digit = bytes[i] & 0xFF;
            int temp = remainder * base + digit;
            bytes[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    private static byte[] doubleHash(byte[] message, int len) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message, 0, len);
            return digest.digest(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return new byte[0];
        }
    }

    static {
        Arrays.fill(_reverseTable, -1);
        for (int i = 0; i < _indexTable.length; ++i) {
            Base58._reverseTable[Base58._indexTable[i]] = i;
        }
    }
}

