/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Item;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.InvalidFormatException;
import java.util.List;
import java.util.UUID;

public class Tag
extends Item {
    public static final String HEADER = "TAG";
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.ISU, Claim.KID, Claim.MTD, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 3;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Tag(UUID issuerId) {
        this(issuerId, (String)null);
    }

    public Tag(UUID issuerId, String context) {
        if (issuerId == null) {
            throw new IllegalArgumentException("Issuer identifier must not be null.");
        }
        if (context != null && context.length() > 84) {
            throw new IllegalArgumentException("Context must not be longer than 84.");
        }
        this.setClaimValue(Claim.UID, UUID.randomUUID());
        this.setClaimValue(Claim.ISS, issuerId);
        this.setClaimValue(Claim.CTX, context);
    }

    public Tag(UUID issuerId, List<Item> items) {
        this(issuerId, null, items);
    }

    public Tag(UUID issuerId, String context, List<Item> items) {
        this(issuerId, context);
        if (items != null) {
            this.setItemLinks(items);
        }
    }

    Tag() {
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected String forExport() throws InvalidFormatException {
        if (this.itemLinks == null || this.itemLinks.isEmpty()) {
            throw new IllegalStateException("Unable to export tag, must contain at least 1 linked item.");
        }
        if (!this.isSigned()) {
            throw new IllegalStateException("Unable to export tag, must be signed first.");
        }
        return super.forExport();
    }

    @Override
    protected void customDecoding(List<String> components) {
        this.isSigned = true;
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 3;
    }
}

