/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.enums;

public enum KeyCapability {
    UNDEFINED,
    SIGN,
    EXCHANGE,
    ENCRYPT,
    AUTHENTICATE;


    public String toString() {
        return super.toString().toLowerCase();
    }

    public static KeyCapability fromString(String capability) {
        return KeyCapability.valueOf(capability.toLowerCase());
    }

    public static KeyCapability keyCapabilityFromLegacy(String legacy) {
        switch (legacy.toLowerCase()) {
            case "identity": {
                return SIGN;
            }
            case "exchange": {
                return EXCHANGE;
            }
            case "encryption": {
                return ENCRYPT;
            }
            case "authentication": {
                return AUTHENTICATE;
            }
        }
        return UNDEFINED;
    }

    public static String legacyFromKeyCapability(KeyCapability capability) {
        switch (capability) {
            case SIGN: {
                return "identity";
            }
            case EXCHANGE: {
                return "exchange";
            }
            case ENCRYPT: {
                return "encryption";
            }
            case AUTHENTICATE: {
                return "authentication";
            }
        }
        return "undefined";
    }
}

