/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Dime;
import io.dimeformat.Identity;
import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.enums.IdentityCapability;
import io.dimeformat.enums.KeyCapability;
import io.dimeformat.exceptions.CapabilityException;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.IntegrityStateException;
import io.dimeformat.keyring.IntegrityState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class IdentityIssuingRequest
extends Item {
    public static final String HEADER = "IIR";
    private Key _publicKey;
    private List<IdentityCapability> _capabilities;
    private Map<String, Object> _principles;
    private static final List<Claim> allowedClaims = List.of(Claim.AMB, Claim.AUD, Claim.CTX, Claim.EXP, Claim.IAT, Claim.ISS, Claim.ISU, Claim.KID, Claim.MTD, Claim.PRI, Claim.SUB, Claim.SYS, Claim.UID);
    private static final int MINIMUM_NBR_COMPONENTS = 3;

    @Override
    public String getHeader() {
        return HEADER;
    }

    public Key getPublicKey() {
        if (this._publicKey == null) {
            try {
                this._publicKey = new Key(List.of(KeyCapability.SIGN), (String)this.getClaim(Claim.PUB), Claim.PUB);
            }
            catch (CryptographyException e) {
                return null;
            }
        }
        return this._publicKey;
    }

    public List<IdentityCapability> getCapabilities() {
        if (this._capabilities == null) {
            List caps = (List)this.getClaim(Claim.CAP);
            this._capabilities = caps.stream().map(IdentityCapability::fromString).collect(Collectors.toList());
        }
        return this._capabilities;
    }

    public Map<String, Object> getPrinciples() {
        Map pri;
        if (this._principles == null && (pri = (Map)this.getClaim(Claim.PRI)) != null) {
            this._principles = Collections.unmodifiableMap(pri);
        }
        return this._principles;
    }

    public static IdentityIssuingRequest generateIIR(Key key) throws CryptographyException {
        return IdentityIssuingRequest.generateIIR(key, null, null);
    }

    public static IdentityIssuingRequest generateIIR(Key key, IdentityCapability[] capabilities) throws CryptographyException {
        return IdentityIssuingRequest.generateIIR(key, capabilities, null);
    }

    public static IdentityIssuingRequest generateIIR(Key key, IdentityCapability[] capabilities, Map<String, Object> principles) throws CryptographyException {
        if (!key.getCapability().contains((Object)KeyCapability.SIGN)) {
            throw new IllegalArgumentException("Key must have SIGN capability set.");
        }
        if (key.getSecret() == null) {
            throw new IllegalArgumentException("Private key must not be null");
        }
        if (key.getPublic() == null) {
            throw new IllegalArgumentException("Public key must not be null");
        }
        IdentityIssuingRequest iir = new IdentityIssuingRequest();
        iir.setClaimValue(Claim.UID, UUID.randomUUID());
        iir.setClaimValue(Claim.IAT, Utility.createTimestamp());
        iir.setClaimValue(Claim.PUB, key.getPublic());
        if (capabilities == null || capabilities.length == 0) {
            capabilities = new IdentityCapability[]{IdentityCapability.GENERIC};
        }
        List<IdentityCapability> caps = List.of(capabilities);
        iir.setClaimValue(Claim.CAP, caps.stream().map(IdentityCapability::toString).collect(Collectors.toList()));
        if (principles != null && !principles.isEmpty()) {
            iir.setClaimValue(Claim.PRI, principles);
        }
        if (key.isLegacy()) {
            iir.markAsLegacy();
        }
        iir.sign(key);
        return iir;
    }

    public boolean wantsCapability(IdentityCapability capability) {
        return this.getCapabilities().contains((Object)capability);
    }

    public Identity issueIdentity(UUID subjectId, long validFor, Key issuerKey, Identity issuerIdentity, boolean includeChain, IdentityCapability[] allowedCapabilities, IdentityCapability[] requiredCapabilities) throws CapabilityException, CryptographyException, IntegrityStateException {
        return this.issueIdentity(subjectId, validFor, issuerKey, issuerIdentity, includeChain, allowedCapabilities, requiredCapabilities, null, null);
    }

    public Identity issueIdentity(UUID subjectId, long validFor, Key issuerKey, Identity issuerIdentity, boolean includeChain, IdentityCapability[] allowedCapabilities, IdentityCapability[] requiredCapabilities, String systemName, String[] ambit) throws CapabilityException, CryptographyException, IntegrityStateException {
        return this.issueIdentity(subjectId, validFor, issuerKey, issuerIdentity, includeChain, allowedCapabilities, requiredCapabilities, systemName, ambit, null);
    }

    public Identity issueIdentity(UUID subjectId, long validFor, Key issuerKey, Identity issuerIdentity, boolean includeChain, IdentityCapability[] allowedCapabilities, IdentityCapability[] requiredCapabilities, String systemName, String[] ambit, String[] methods) throws CapabilityException, CryptographyException, IntegrityStateException {
        if (issuerIdentity == null) {
            throw new IllegalArgumentException("Issuer identity must not be null.");
        }
        String sys = systemName != null && systemName.length() > 0 ? systemName : (String)issuerIdentity.getClaim(Claim.SYS);
        return this.issueNewIdentity(sys, subjectId, validFor, issuerKey, issuerIdentity, includeChain, allowedCapabilities, requiredCapabilities, ambit, methods);
    }

    public Identity selfIssueIdentity(UUID subjectId, long validFor, Key issuerKey, String systemName) throws CryptographyException {
        return this.selfIssueIdentity(subjectId, validFor, issuerKey, systemName, null, null);
    }

    public Identity selfIssueIdentity(UUID subjectId, long validFor, Key issuerKey, String systemName, String[] ambit) throws CryptographyException {
        return this.selfIssueIdentity(subjectId, validFor, issuerKey, systemName, ambit, null);
    }

    public Identity selfIssueIdentity(UUID subjectId, long validFor, Key issuerKey, String systemName, String[] ambit, String[] methods) throws CryptographyException {
        try {
            if (systemName == null || systemName.length() == 0) {
                throw new IllegalArgumentException("System name must not be null or empty.");
            }
            return this.issueNewIdentity(systemName, subjectId, validFor, issuerKey, null, false, null, null, ambit, methods);
        }
        catch (CapabilityException | IntegrityStateException e) {
            return null;
        }
    }

    @Override
    public void convertToLegacy() {
        if (this.isLegacy()) {
            return;
        }
        super.convertToLegacy();
        Key.convertKeyToLegacy(this, KeyCapability.SIGN, Claim.PUB);
    }

    @Override
    protected boolean allowedToSetClaimDirectly(Claim claim) {
        return allowedClaims.contains((Object)claim);
    }

    @Override
    protected void customDecoding(List<String> components) {
        this.isSigned = true;
    }

    @Override
    protected int getMinNbrOfComponents() {
        return 3;
    }

    private Identity issueNewIdentity(String systemName, UUID subjectId, long validFor, Key issuerKey, Identity issuerIdentity, boolean includeChain, IdentityCapability[] allowedCapabilities, IdentityCapability[] requiredCapabilities, String[] ambit, String[] methods) throws IntegrityStateException, CapabilityException, CryptographyException {
        boolean isSelfSign = this.getPublicKey().getPublic().equals(issuerKey.getPublic());
        if (isSelfSign && issuerIdentity != null) {
            throw new IllegalArgumentException("Unable to issue new identity since both issuing public key and issued public key is the same.");
        }
        this.strip();
        this.completeCapabilities(allowedCapabilities, requiredCapabilities, isSelfSign);
        if (isSelfSign || issuerIdentity.hasCapability(IdentityCapability.ISSUE)) {
            Instant now = Utility.createTimestamp();
            Instant expires = now.plusSeconds(validFor);
            UUID issuerId = issuerIdentity != null ? (UUID)issuerIdentity.getClaim(Claim.SUB) : subjectId;
            List<String> ambitList = ambit != null ? List.of(ambit) : null;
            List<String> methodList = methods != null ? List.of(methods) : null;
            Identity identity = new Identity(systemName, subjectId, this.getPublicKey(), now, expires, issuerId, (List)this.getClaim(Claim.CAP), this.getPrinciples(), ambitList, methodList);
            if (issuerIdentity != null) {
                IntegrityState state = issuerIdentity.verifyDates();
                if (!state.isValid()) {
                    throw new IntegrityStateException(state, "Unable to verify valid dates of issuer identity.");
                }
                if (includeChain && !Dime.keyRing.containsItem(issuerIdentity)) {
                    identity.setTrustChain(issuerIdentity);
                }
            }
            if (this.isLegacy()) {
                identity.markAsLegacy();
            }
            identity.sign(issuerKey);
            return identity;
        }
        throw new CapabilityException("Issuing identity missing ISSUE capability.");
    }

    private void completeCapabilities(IdentityCapability[] allowedCapabilities, IdentityCapability[] requiredCapabilities, boolean isSelfIssue) throws CapabilityException {
        ArrayList caps = (ArrayList)this.getClaim(Claim.CAP);
        ArrayList capabilities = caps != null ? (ArrayList)caps.stream().map(IdentityCapability::fromString).collect(Collectors.toList()) : new ArrayList();
        if (isSelfIssue) {
            if (!this.wantsCapability(IdentityCapability.SELF)) {
                capabilities.add(IdentityCapability.SELF);
            }
        } else {
            if (this.wantsCapability(IdentityCapability.SELF)) {
                throw new IllegalArgumentException("Unable to issue identity, only self-issued identities may request SELF capability.");
            }
            if (!(allowedCapabilities != null && allowedCapabilities.length != 0 || requiredCapabilities != null && requiredCapabilities.length != 0)) {
                throw new IllegalArgumentException("Unable to issue identity, allowed capabilities and/or required capabilities must be defined to issue identity.");
            }
            if (requiredCapabilities != null && requiredCapabilities.length > 0) {
                ArrayList<IdentityCapability> tempRequiredCapabilities = new ArrayList<IdentityCapability>(Arrays.asList(requiredCapabilities));
                tempRequiredCapabilities.removeAll(capabilities);
                if (!tempRequiredCapabilities.isEmpty()) {
                    capabilities.addAll(tempRequiredCapabilities);
                }
            }
            if (allowedCapabilities != null && allowedCapabilities.length > 0) {
                ArrayList tempCap = new ArrayList(capabilities);
                tempCap.removeAll(Arrays.asList(allowedCapabilities));
                if (!tempCap.isEmpty()) {
                    throw new CapabilityException("Unable to issue identity, identity issuing request contains one or more disallowed capabilities.");
                }
            }
        }
        this.setClaimValue(Claim.CAP, capabilities.stream().map(cap -> cap.toString().toLowerCase()).collect(Collectors.toList()));
    }
}

