/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Dime;
import io.dimeformat.Item;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class ItemLink {
    public final String itemIdentifier;
    public final String thumbprint;
    public final UUID uniqueId;
    public String cryptoSuiteName;

    public ItemLink(Item item) {
        this(item, null);
    }

    public ItemLink(Item item, String cryptoSuiteName) {
        if (item == null) {
            throw new IllegalArgumentException("Provided item must not be null.");
        }
        this.itemIdentifier = item.getHeader();
        try {
            this.thumbprint = item.generateThumbprint();
        }
        catch (CryptographyException e) {
            throw new IllegalArgumentException("Unable to create item link, exception caught: " + e);
        }
        this.uniqueId = (UUID)item.getClaim(Claim.UID);
        this.cryptoSuiteName = cryptoSuiteName != null ? cryptoSuiteName : Dime.crypto.getDefaultSuiteName();
    }

    public ItemLink(String itemIdentifier, String thumbprint, UUID uniqueId, String cryptoSuiteName) {
        if (itemIdentifier == null || itemIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Provided item identifier must not be null or empty.");
        }
        if (thumbprint == null || thumbprint.isEmpty()) {
            throw new IllegalArgumentException("Provided thumbprint must not be null or empty.");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("Provided unique ID must not be null.");
        }
        if (cryptoSuiteName == null || cryptoSuiteName.isEmpty()) {
            throw new IllegalArgumentException("Provided cryptographic suite name must not be null.");
        }
        this.itemIdentifier = itemIdentifier;
        this.thumbprint = thumbprint;
        this.uniqueId = uniqueId;
        this.cryptoSuiteName = cryptoSuiteName;
    }

    public static ItemLink fromEncoded(String encoded) throws InvalidFormatException {
        if (encoded == null || encoded.isEmpty()) {
            throw new IllegalArgumentException("Encoded item link must not be null or empty.");
        }
        String[] components = encoded.split("\\.");
        if (components.length < 3) {
            throw new InvalidFormatException("Invalid item link format.");
        }
        String suiteName = components.length == 4 ? components[3] : "STN";
        return new ItemLink(components[0], components[2], UUID.fromString(components[1]), suiteName);
    }

    public static List<ItemLink> fromEncodedList(String encodedList) throws InvalidFormatException {
        if (encodedList == null || encodedList.isEmpty()) {
            throw new IllegalArgumentException("Encoded list of item links must not be null or empty.");
        }
        String[] items = encodedList.split(":");
        ArrayList<ItemLink> links = new ArrayList<ItemLink>();
        for (String item : items) {
            links.add(ItemLink.fromEncoded(item));
        }
        return links;
    }

    public boolean verify(Item item) {
        if (item == null) {
            return false;
        }
        try {
            return this.uniqueId.equals(item.getClaim(Claim.UID)) && this.itemIdentifier.equals(item.getHeader()) && this.thumbprint.equals(item.generateThumbprint(this.cryptoSuiteName));
        }
        catch (CryptographyException e) {
            return false;
        }
    }

    public static IntegrityState verify(List<Item> items, List<ItemLink> links) {
        if (items == null || links == null) {
            throw new NullPointerException("Unable to verify linked items, provided lists must not be null.");
        }
        for (Item item : items) {
            boolean matchFound = false;
            for (ItemLink link : links) {
                if (!link.uniqueId.equals(item.getClaim(Claim.UID))) continue;
                matchFound = true;
                try {
                    if (link.itemIdentifier.equals(item.getHeader()) && link.thumbprint.equals(item.generateThumbprint(link.cryptoSuiteName))) continue;
                    return IntegrityState.FAILED_LINKED_ITEM_FAULT;
                }
                catch (CryptographyException e) {
                    return IntegrityState.FAILED_INTERNAL_FAULT;
                }
            }
            if (matchFound) continue;
            return IntegrityState.FAILED_LINKED_ITEM_MISMATCH;
        }
        return items.size() == links.size() ? IntegrityState.VALID_ITEM_LINKS : IntegrityState.PARTIALLY_VALID_ITEM_LINKS;
    }

    String toEncoded() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.itemIdentifier).append(".").append(this.uniqueId.toString()).append(".").append(this.thumbprint);
        if (this.cryptoSuiteName != null && !this.cryptoSuiteName.equals("STN")) {
            builder.append(".").append(this.cryptoSuiteName);
        }
        return builder.toString();
    }

    static String toEncoded(List<ItemLink> links) {
        if (links == null || links.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ItemLink link : links) {
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(link.toEncoded());
        }
        return builder.toString();
    }
}

