/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat.crypto;

import io.dimeformat.Base58;
import io.dimeformat.Item;
import io.dimeformat.Key;
import io.dimeformat.crypto.NaClSuite;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;

@Deprecated
class LegacySuite
extends NaClSuite {
    static final String LEGACY_DSC_SUITE = "DSC";
    static final String LEGACY_STN_SUITE = "STN";

    public LegacySuite(String name) {
        super(name);
    }

    @Override
    public byte[] generateSignature(Item item, Key key) throws CryptographyException {
        byte[] signature = new byte[64];
        byte[] data = item.rawEncoded(false);
        int result = this._sodium.crypto_sign_detached(signature, null, data, (long)data.length, key.getKeyBytes(Claim.KEY));
        if (result != 0) {
            throw new CryptographyException("Failed to generate signature, error code returned: " + result);
        }
        return signature;
    }

    @Override
    public boolean verifySignature(Item item, byte[] signature, Key key) throws CryptographyException {
        byte[] keyBytes = key.getKeyBytes(Claim.PUB);
        if (keyBytes == null || keyBytes.length == 0) {
            throw new IllegalArgumentException("Unable to verify signature, missing public key.");
        }
        byte[] data = item.rawEncoded(false);
        return this._sodium.crypto_sign_verify_detached(signature, data, (long)data.length, key.getKeyBytes(Claim.PUB)) == 0;
    }

    @Override
    public String encodeKeyBytes(byte[] rawKey, Claim claim) {
        if (this._suiteName.equals(LEGACY_STN_SUITE)) {
            return Base58.encode(rawKey);
        }
        return super.encodeKeyBytes(rawKey, claim);
    }

    @Override
    public byte[] decodeKeyBytes(String encodedKey, Claim claim) {
        if (this._suiteName.equals(LEGACY_STN_SUITE)) {
            return Base58.decode(encodedKey);
        }
        return super.decodeKeyBytes(encodedKey, claim);
    }
}

