/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.Base58;
import io.dimeformat.ItemLink;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.InvalidFormatException;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.webpki.jcs.JsonCanonicalizer;

class ClaimsMap {
    protected HashMap<String, Object> _claims;

    ClaimsMap() {
        this._claims = new HashMap();
    }

    ClaimsMap(String encoded) {
        this._claims = ClaimsMap.fromJSON(encoded);
    }

    String toJSON() throws IOException {
        if (this._claims == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(this._claims);
        JsonCanonicalizer jsonCanonicalizer = new JsonCanonicalizer(jsonObject.toString());
        return jsonCanonicalizer.getEncodedString();
    }

    int size() {
        return this._claims != null ? this._claims.size() : 0;
    }

    <T> T get(Claim claim) {
        if (this._claims == null) {
            return null;
        }
        return (T)(switch (claim) {
            case Claim.AUD, Claim.ISS, Claim.KID, Claim.SUB, Claim.UID -> this.getUUID(claim);
            case Claim.EXP, Claim.IAT -> this.getInstant(claim);
            case Claim.LNK -> this.getItemLinks(claim);
            default -> this._claims.get(claim.toString());
        });
    }

    void put(Claim claim, Object value) {
        if (value != null) {
            if (this._claims == null) {
                this._claims = new HashMap();
            }
            if (value instanceof byte[]) {
                this._claims.put(claim.toString(), Base58.encode((byte[])value));
            } else {
                this._claims.put(claim.toString(), value);
            }
        }
    }

    void remove(Claim claim) {
        if (this._claims == null) {
            return;
        }
        this._claims.remove(claim.toString());
    }

    Map<Claim, Object> copyClaims() {
        if (this._claims != null) {
            HashMap<Claim, Object> claims = new HashMap<Claim, Object>();
            for (String key : this._claims.keySet()) {
                Claim claim = Claim.valueOf(key.toUpperCase());
                claims.put(claim, this._claims.get(key));
            }
            return claims;
        }
        return null;
    }

    private static HashMap<String, Object> fromJSON(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            return (HashMap)jsonObject.toMap();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private UUID getUUID(Claim claim) {
        Object object = this._claims.get(claim.toString());
        if (object == null) {
            return null;
        }
        if (object instanceof UUID) {
            return (UUID)object;
        }
        if (object instanceof String) {
            UUID uuid = UUID.fromString((String)object);
            this._claims.put(claim.toString(), uuid);
            return uuid;
        }
        throw new IllegalArgumentException("Claim with name " + claim + " is not a UUID object.");
    }

    private Instant getInstant(Claim claim) {
        Object object = this._claims.get(claim.toString());
        if (object == null) {
            return null;
        }
        if (object instanceof Instant) {
            return (Instant)object;
        }
        if (object instanceof String) {
            Instant instant = Instant.parse((String)object);
            this._claims.put(claim.toString(), instant);
            return instant;
        }
        throw new IllegalArgumentException("Claim with name " + claim + " is not an Instant object.");
    }

    private List<ItemLink> getItemLinks(Claim claim) {
        String string = (String)this._claims.get(claim.toString());
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return ItemLink.fromEncodedList(string);
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }
}

