/*
 * Decompiled with CFR 0.152.
 */
package io.dimeformat;

import io.dimeformat.ClaimsMap;
import io.dimeformat.Data;
import io.dimeformat.Dime;
import io.dimeformat.Envelope;
import io.dimeformat.Identity;
import io.dimeformat.IdentityIssuingRequest;
import io.dimeformat.ItemLink;
import io.dimeformat.Key;
import io.dimeformat.Message;
import io.dimeformat.Signature;
import io.dimeformat.Tag;
import io.dimeformat.Utility;
import io.dimeformat.enums.Claim;
import io.dimeformat.exceptions.CryptographyException;
import io.dimeformat.exceptions.InvalidFormatException;
import io.dimeformat.keyring.IntegrityState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class Item {
    static final int MINIMUM_NBR_COMPONENTS = 2;
    static final int COMPONENTS_IDENTIFIER_INDEX = 0;
    static final int COMPONENTS_CLAIMS_INDEX = 1;
    protected String encoded;
    protected List<String> components;
    protected List<ItemLink> itemLinks;
    protected boolean isSigned = false;
    private ClaimsMap _claims;
    private List<Signature> _signatureList;
    @Deprecated
    private boolean legacy = false;

    public abstract String getHeader();

    public boolean isSigned() {
        return this.isSigned;
    }

    public List<Signature> getSignatures() {
        if (this.isSigned()) {
            return Collections.unmodifiableList(this._signatureList);
        }
        return null;
    }

    public Map<Claim, Object> getClaims() {
        return this.getClaimMap().copyClaims();
    }

    public <T> T getClaim(Claim claim) {
        return this.getClaimMap().get(claim);
    }

    public void putClaim(Claim claim, Object value) {
        this.throwIfSigned();
        if (!this.allowedToSetClaimDirectly(claim)) {
            throw new IllegalArgumentException("Unable to set claim '" + claim + "', may be unsupported or locked.");
        }
        this.setClaimValue(claim, value);
    }

    public void removeClaim(Claim claim) {
        this.throwIfSigned();
        this.getClaimMap().remove(claim);
    }

    public static <T extends Item> T importFromEncoded(String encoded) throws InvalidFormatException {
        try {
            Envelope envelope = Envelope.importFromEncoded(encoded);
            List<Item> items = envelope.getItems();
            if (items.size() > 1) {
                throw new InvalidFormatException("Multiple items found, import as 'Envelope' instead. (I1001)");
            }
            return (T)items.get(0);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String exportToEncoded() {
        Envelope envelope = new Envelope();
        if (this.isLegacy()) {
            envelope.convertToLegacy();
        }
        envelope.addItem(this);
        return envelope.exportToEncoded();
    }

    public String toString() {
        return this.exportToEncoded();
    }

    public byte[] rawEncoded(boolean withSignatures) {
        try {
            return this.encoded(withSignatures).getBytes(StandardCharsets.UTF_8);
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    public boolean hasAmbit(String ambit) {
        List ambitList = (List)this.getClaim(Claim.AMB);
        if (ambitList != null) {
            return ambitList.contains(ambit);
        }
        return false;
    }

    public void sign(Key signingKey) throws CryptographyException {
        if (this.isLegacy() && this.isSigned()) {
            throw new IllegalStateException("Unable to sign, legacy item is already signed.");
        }
        if (signingKey == null || signingKey.getSecret() == null) {
            throw new IllegalArgumentException("Unable to sign, key for signing must not be null. (I1004)");
        }
        if (this.isSigned() && Signature.find(Dime.crypto.generateKeyName(signingKey), this.extractSignatures()) != null) {
            throw new IllegalStateException("Item already signed with provided key.");
        }
        try {
            Signature signature = Dime.crypto.generateSignature(this, signingKey);
            this.extractSignatures().add(signature);
            this.isSigned = true;
        }
        catch (Exception e) {
            throw new CryptographyException("Unable to sign item, invalid data.");
        }
    }

    public boolean strip() {
        this.encoded = null;
        this.components = null;
        this._signatureList = null;
        this.isSigned = false;
        return true;
    }

    public boolean strip(Key key) {
        if (this.isLegacy() || !this.isSigned()) {
            return false;
        }
        String identifier = Dime.crypto.generateKeyName(key);
        Signature signature = Signature.find(identifier, this.extractSignatures());
        if (signature != null) {
            return this.extractSignatures().remove(signature);
        }
        return false;
    }

    public String generateThumbprint() throws CryptographyException {
        return this.generateThumbprint(true, Dime.crypto.getDefaultSuiteName());
    }

    public String generateThumbprint(boolean includeSignatures) throws CryptographyException {
        return this.generateThumbprint(includeSignatures, Dime.crypto.getDefaultSuiteName());
    }

    public String generateThumbprint(boolean includeSignatures, String suiteName) throws CryptographyException {
        try {
            return Item.thumbprint(this.encoded(includeSignatures), suiteName);
        }
        catch (InvalidFormatException e) {
            throw new CryptographyException("Unable to generate thumbprint for item, data invalid.");
        }
    }

    public static String thumbprint(String encoded) throws CryptographyException {
        return Item.thumbprint(encoded, Dime.crypto.getDefaultSuiteName());
    }

    public static String thumbprint(String encoded, String suiteName) throws CryptographyException {
        return Dime.crypto.generateHash(encoded.getBytes(StandardCharsets.UTF_8), suiteName);
    }

    public IntegrityState verify(Identity issuingIdentity) {
        return this.verify(issuingIdentity, null);
    }

    public IntegrityState verify(Identity trustedIdentity, List<Item> linkedItems) {
        UUID issuerId = (UUID)this.getClaim(Claim.ISS);
        if (issuerId != null && !issuerId.equals(trustedIdentity.getClaim(Claim.SUB))) {
            return IntegrityState.FAILED_ISSUER_MISMATCH;
        }
        IntegrityState state = trustedIdentity.verifyDates();
        if (!state.isValid()) {
            return state;
        }
        return this.verify(trustedIdentity.getPublicKey(), linkedItems);
    }

    public IntegrityState verify() {
        return this.verify((Key)null, null);
    }

    public IntegrityState verify(Key verifyKey) {
        return this.verify(verifyKey, null);
    }

    public IntegrityState verify(Key verifyKey, List<Item> linkedItems) {
        IntegrityState state = this.verifyDates();
        if (!state.isValid()) {
            return state;
        }
        boolean partiallyIntact = false;
        if (linkedItems != null) {
            state = this.verifyLinkedItems(linkedItems);
            if (!state.isValid()) {
                return state;
            }
            boolean bl = partiallyIntact = state == IntegrityState.PARTIALLY_VALID_ITEM_LINKS;
        }
        return !(state = this.verifySignature(verifyKey)).isValid() ? state : (partiallyIntact ? IntegrityState.INTACT : (linkedItems == null && this.getClaim(Claim.LNK) != null ? IntegrityState.PARTIALLY_COMPLETE : IntegrityState.COMPLETE));
    }

    public IntegrityState verifyDates() {
        if (!this.hasClaims()) {
            return IntegrityState.VALID_DATES;
        }
        Instant now = Utility.createTimestamp();
        if (Utility.gracefulTimestampCompare((Instant)this.getClaim(Claim.IAT), now) > 0) {
            return IntegrityState.FAILED_USED_BEFORE_ISSUED;
        }
        if (this.getClaim(Claim.EXP) != null) {
            if (Utility.gracefulTimestampCompare((Instant)this.getClaim(Claim.IAT), (Instant)this.getClaim(Claim.EXP)) > 0) {
                return IntegrityState.FAILED_DATE_MISMATCH;
            }
            if (Utility.gracefulTimestampCompare((Instant)this.getClaim(Claim.EXP), now) < 0) {
                return IntegrityState.FAILED_USED_AFTER_EXPIRED;
            }
        }
        return IntegrityState.VALID_DATES;
    }

    public IntegrityState verifySignature(Key verifyKey) {
        Signature signature;
        if (!this.isSigned()) {
            return IntegrityState.FAILED_NO_SIGNATURE;
        }
        if (verifyKey == null) {
            return Dime.keyRing.verify(this);
        }
        Signature signature2 = signature = this.isLegacy() ? this.extractSignatures().get(0) : Signature.find(Dime.crypto.generateKeyName(verifyKey), this.extractSignatures());
        if (signature == null) {
            return IntegrityState.FAILED_KEY_MISMATCH;
        }
        try {
            return Dime.crypto.verifySignature(this, signature, verifyKey) ? IntegrityState.VALID_SIGNATURE : IntegrityState.FAILED_NOT_TRUSTED;
        }
        catch (Exception e) {
            return IntegrityState.FAILED_INTERNAL_FAULT;
        }
    }

    public IntegrityState verifyLinkedItems(List<Item> linkedItems) {
        if (this.itemLinks == null) {
            this.itemLinks = (List)this.getClaim(Claim.LNK);
        }
        if (this.itemLinks != null) {
            return ItemLink.verify(linkedItems, this.itemLinks);
        }
        return IntegrityState.FAILED_LINKED_ITEM_MISSING;
    }

    public void addItemLink(Item item) {
        this.throwIfSigned();
        if (item == null) {
            throw new IllegalArgumentException("Item to link with must not be null.");
        }
        if (this.itemLinks == null) {
            this.itemLinks = new ArrayList<ItemLink>();
        }
        String cryptoSuite = !this.isLegacy() ? Dime.crypto.getDefaultSuiteName() : null;
        this.itemLinks.add(new ItemLink(item, cryptoSuite));
    }

    public void setItemLinks(List<Item> items) {
        this.throwIfSigned();
        if (items == null) {
            throw new IllegalArgumentException("Items to link with must not be null.");
        }
        this.itemLinks = new ArrayList<ItemLink>();
        String cryptoSuite = !this.isLegacy() ? Dime.crypto.getDefaultSuiteName() : null;
        for (Item item : items) {
            this.itemLinks.add(new ItemLink(item, cryptoSuite));
        }
    }

    public List<ItemLink> getItemLinks() {
        if (this.itemLinks == null) {
            this.itemLinks = (List)this.getClaim(Claim.LNK);
        }
        return this.itemLinks;
    }

    public void removeLinkItems() {
        this.throwIfSigned();
        this.getClaimMap().remove(Claim.LNK);
        this.itemLinks = null;
    }

    @Deprecated
    public void convertToLegacy() {
        this.strip();
        if (this.getItemLinks() != null) {
            for (ItemLink link : this.getItemLinks()) {
                link.cryptoSuiteName = null;
            }
        }
        this.legacy = true;
    }

    @Deprecated
    public boolean isLegacy() {
        return this.legacy;
    }

    @Deprecated
    void markAsLegacy() {
        this.legacy = true;
    }

    static <T extends Item> T fromEncoded(String encoded) throws InvalidFormatException {
        try {
            int index = encoded.indexOf(".");
            if (index == -1) {
                return null;
            }
            Item item = Item.itemFromHeader(encoded.substring(0, index));
            item.decode(encoded);
            return (T)item;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected and fatal exception caught while encoding item: ", e);
        }
    }

    String forExport() throws InvalidFormatException {
        return this.encoded(true);
    }

    protected void setClaimValue(Claim claim, Object value) {
        this.getClaimMap().put(claim, value);
    }

    protected abstract boolean allowedToSetClaimDirectly(Claim var1);

    protected String exportClaims() throws IOException {
        return this.getClaimMap().toJSON();
    }

    protected final boolean hasClaims() {
        return this.getClaimMap().size() > 0;
    }

    protected final List<Signature> extractSignatures() {
        if (this._signatureList == null) {
            this._signatureList = this.isSigned() ? Signature.fromEncoded(this.components.get(this.components.size() - 1)) : new ArrayList<Signature>();
        }
        return this._signatureList;
    }

    protected String encoded(boolean withSignature) throws InvalidFormatException {
        if (this.encoded == null) {
            StringBuilder builder = new StringBuilder();
            this.customEncoding(builder);
            this.encoded = builder.toString();
        }
        if (withSignature && this.isSigned()) {
            return this.encoded + "." + Signature.toEncoded(this.extractSignatures());
        }
        return this.encoded;
    }

    protected void customEncoding(StringBuilder builder) throws InvalidFormatException {
        builder.append(this.getHeader());
        builder.append(".");
        if (this.itemLinks != null && !this.itemLinks.isEmpty()) {
            this.getClaimMap().put(Claim.LNK, ItemLink.toEncoded(this.itemLinks));
        }
        try {
            builder.append(Utility.toBase64(this._claims.toJSON()));
        }
        catch (IOException e) {
            throw new InvalidFormatException("Unexpected exception while encoding item: " + e);
        }
    }

    protected final void decode(String encoded) throws InvalidFormatException {
        this.components = new ArrayList<String>(Arrays.asList(this.getComponents(encoded)));
        this.customDecoding(this.components);
        if (this.isSigned()) {
            if (this.extractSignatures().get(0).isLegacy()) {
                this.markAsLegacy();
            }
            this.encoded = encoded.substring(0, encoded.lastIndexOf("."));
        } else {
            this.encoded = encoded;
        }
    }

    protected abstract void customDecoding(List<String> var1) throws InvalidFormatException;

    protected int getMinNbrOfComponents() {
        return 2;
    }

    protected final void throwIfSigned() {
        if (this.isSigned()) {
            throw new IllegalStateException("Unable to complete operation, DiME item already signed.");
        }
    }

    private String[] getComponents(String encoded) throws InvalidFormatException {
        String[] array = encoded.split("\\.");
        if (array.length < this.getMinNbrOfComponents()) {
            throw new InvalidFormatException("Unexpected number of components for Dime item, expected at least " + this.getMinNbrOfComponents() + ", got " + array.length + ".");
        }
        if (array[0].compareTo(this.getHeader()) != 0) {
            throw new InvalidFormatException("Unexpected Dime item identifier, expected: " + this.getHeader() + ", got " + array[0] + ".");
        }
        return array;
    }

    private ClaimsMap getClaimMap() {
        if (this._claims != null) {
            return this._claims;
        }
        if (this.components != null && this.components.size() > 1) {
            byte[] jsonClaims = Utility.fromBase64(this.components.get(1));
            this._claims = new ClaimsMap(new String(jsonClaims, StandardCharsets.UTF_8));
        } else {
            this._claims = new ClaimsMap();
        }
        return this._claims;
    }

    private static Item itemFromHeader(String header) throws Exception {
        Class<?> t = Item.classFromItemHeader(header);
        return (Item)Objects.requireNonNull(t).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static Class<?> classFromItemHeader(String header) throws IllegalArgumentException {
        switch (header) {
            case "DAT": {
                return Data.class;
            }
            case "ID": {
                return Identity.class;
            }
            case "IIR": {
                return IdentityIssuingRequest.class;
            }
            case "KEY": {
                return Key.class;
            }
            case "MSG": {
                return Message.class;
            }
            case "TAG": {
                return Tag.class;
            }
        }
        throw new IllegalArgumentException("Invalid item header: " + header);
    }
}

