/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.math.BigDecimal;
import java.util.Set;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

enum ConstOrLiteralDeclare {
    BOOLEAN{

        @Override
        String className() {
            return Boolean.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return Set.of("TRUE", "FALSE");
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    BYTE{

        @Override
        String className() {
            return Byte.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    SHORT{

        @Override
        String className() {
            return Short.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    INTEGER{

        @Override
        String className() {
            return Integer.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    LONG{

        @Override
        String className() {
            return Long.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    FLOAT{

        @Override
        String className() {
            return Float.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    DOUBLE{

        @Override
        String className() {
            return Double.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    CHARACTER{

        @Override
        String className() {
            return Character.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return NUMBER_DEFAULT_MEMBERS;
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    }
    ,
    BIGDECIMAL{

        @Override
        String className() {
            return BigDecimal.class.getName();
        }

        @Override
        Set<String> publicMembers() {
            return Set.of("ZERO", "ONE", "TEN");
        }

        @Override
        MethodMatchers methodMatchers() {
            return DEFAULT_METHOD_MATCHERS;
        }
    };

    private static final Set<String> NUMBER_DEFAULT_MEMBERS;
    private static final MethodMatchers DEFAULT_METHOD_MATCHERS;

    public boolean isPublicMember(MemberSelectExpressionTree tree) {
        return this.className().equals(tree.expression().symbolType().fullyQualifiedName()) && this.publicMembers().contains(tree.identifier().toString());
    }

    public boolean isLiteralDeclare(MethodInvocationTree tree) {
        return this.methodMatchers().matches(tree) && tree.arguments().stream().allMatch(ConstOrLiteralDeclare::isLiteral);
    }

    abstract String className();

    abstract Set<String> publicMembers();

    abstract MethodMatchers methodMatchers();

    public static final boolean isLiteral(Tree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            arg = ((TypeCastTree)arg).expression();
        }
        return arg.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.FLOAT_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.DOUBLE_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.CHAR_LITERAL});
    }

    static {
        NUMBER_DEFAULT_MEMBERS = Set.of("MIN_VALUE", "MAX_VALUE");
        DEFAULT_METHOD_MATCHERS = MethodMatchers.create().ofSubTypes(new String[]{Number.class.getName(), Boolean.class.getName(), Character.class.getName()}).names(new String[]{"valueOf"}).addParametersMatcher(args -> !args.isEmpty()).build();
    }
}

