/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC2")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="AMIES")
public class AvoidMultipleIfElseStatement
extends IssuableSubscriptionVisitor {
    public static final String ERROR_MESSAGE = "Use a switch statement instead of multiple if-else if possible";
    public static final int NB_MAX_VARIABLE_USAGE = 2;
    private VariablesPerLevelDataStructure variablesStruct = new VariablesPerLevelDataStructure();

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree pTree) {
        MethodTree method = (MethodTree)pTree;
        this.variablesStruct = new VariablesPerLevelDataStructure();
        this.visitNodeContent(method.block().body(), 0);
    }

    private void visitNodeContent(List<StatementTree> pLstStatements, int pLevel) {
        if (pLstStatements == null || pLstStatements.isEmpty()) {
            return;
        }
        for (StatementTree statement : pLstStatements) {
            if (statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.visitNodeContent(((BlockTree)statement).body(), pLevel);
                continue;
            }
            if (!statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) continue;
            this.visitIfNode((IfStatementTree)statement, pLevel);
        }
    }

    private void visitIfNode(IfStatementTree pIfTree, int pLevel) {
        if (pIfTree == null) {
            return;
        }
        this.variablesStruct.reinitVariableUsageForLevel(pLevel + 1);
        this.variablesStruct.reinitVariableUsageForLevelForCurrentIfStruct(pLevel);
        this.computeIfVariables(pIfTree, pLevel);
        this.visitNodeContent(((BlockTree)pIfTree.thenStatement()).body(), pLevel + 1);
        if (pIfTree.elseStatement() != null) {
            if (pIfTree.elseStatement().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.visitElseNode((BlockTree)pIfTree.elseStatement(), pLevel);
            } else if (pIfTree.elseStatement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                this.visitIfNode((IfStatementTree)pIfTree.elseStatement(), pLevel);
            }
        }
    }

    private void computeIfVariables(IfStatementTree pIfTree, int pLevel) {
        if (pIfTree.condition() == null) {
            return;
        }
        ExpressionTree expr = pIfTree.condition();
        if (expr instanceof BinaryExpressionTree) {
            this.computeConditionVariables((BinaryExpressionTree)expr, pLevel);
        }
    }

    private void computeConditionVariables(BinaryExpressionTree pBinExprTree, int pLevel) {
        if (pBinExprTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR})) {
            if (pBinExprTree.leftOperand() instanceof BinaryExpressionTree) {
                this.computeConditionVariables((BinaryExpressionTree)pBinExprTree.leftOperand(), pLevel);
            }
            if (pBinExprTree.rightOperand() instanceof BinaryExpressionTree) {
                this.computeConditionVariables((BinaryExpressionTree)pBinExprTree.rightOperand(), pLevel);
            }
        } else if (pBinExprTree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) || pBinExprTree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN})) {
            if (pBinExprTree.leftOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.computeVariables((IdentifierTree)pBinExprTree.leftOperand(), pLevel);
            }
            if (pBinExprTree.rightOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.computeVariables((IdentifierTree)pBinExprTree.rightOperand(), pLevel);
            }
        }
    }

    private void computeVariables(IdentifierTree pVarIdTree, int pLevel) {
        if (pVarIdTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !pVarIdTree.symbolType().is("float") && !pVarIdTree.symbolType().is("double")) {
            int nbUsed = this.variablesStruct.incrementVariableUsageForLevel(pVarIdTree.name(), pLevel);
            this.variablesStruct.incrementVariableUsageForLevelForCurrentIfStruct(pVarIdTree.name(), pLevel);
            if (nbUsed > 2) {
                this.reportIssue((Tree)pVarIdTree, ERROR_MESSAGE);
            }
        }
    }

    private void visitElseNode(BlockTree pElseTree, int pLevel) {
        if (pElseTree == null) {
            return;
        }
        this.computeElseVariables((StatementTree)pElseTree, pLevel);
        this.visitNodeContent(pElseTree.body(), pLevel + 1);
    }

    private void computeElseVariables(StatementTree pElseTree, int pLevel) {
        Map<String, Integer> mapVar = this.variablesStruct.getVariablesForCurrentIfStruct(pLevel);
        if (mapVar != null) {
            for (Map.Entry<String, Integer> entry : mapVar.entrySet()) {
                String variableName = entry.getKey();
                int nbUsed = this.variablesStruct.incrementVariableUsageForLevel(variableName, pLevel);
                this.variablesStruct.incrementVariableUsageForLevelForCurrentIfStruct(variableName, pLevel);
                if (nbUsed <= 2) continue;
                this.reportIssue((Tree)pElseTree, ERROR_MESSAGE);
            }
        }
    }

    private static class VariablesPerLevelDataStructure {
        private final Map<Integer, Map<String, Integer>> mapVariablesPerLevel = new HashMap<Integer, Map<String, Integer>>(10);
        private final Map<Integer, Map<String, Integer>> mapVariablesPerLevelForCurrentIfStruct = new HashMap<Integer, Map<String, Integer>>(10);

        public int incrementVariableUsageForLevel(String variableName, int pLevel) {
            return this.internalIncrementVariableUsage(this.mapVariablesPerLevel, variableName, pLevel);
        }

        private int internalIncrementVariableUsage(Map<Integer, Map<String, Integer>> pDataMap, String variableName, int pLevel) {
            Map variablesMap = pDataMap.computeIfAbsent(pLevel, k -> new HashMap(5));
            Integer nbUsed = (Integer)variablesMap.get(variableName);
            if (nbUsed == null) {
                Integer nbParentUsed = this.internalGetVariableUsageOfNearestParent(pDataMap, variableName, pLevel - 1);
                nbUsed = nbParentUsed == null ? 0 : nbParentUsed;
            }
            Integer n = nbUsed;
            Integer n2 = nbUsed = Integer.valueOf(nbUsed + 1);
            variablesMap.put(variableName, nbUsed);
            return nbUsed;
        }

        private Integer internalGetVariableUsageOfNearestParent(Map<Integer, Map<String, Integer>> pDataMap, String variableName, int pLevel) {
            Integer nbParentUsed = null;
            for (int i = pLevel; i >= 0 && nbParentUsed == null; --i) {
                Map<String, Integer> variablesParentLevelMap = pDataMap.get(i);
                nbParentUsed = variablesParentLevelMap.get(variableName);
            }
            return nbParentUsed;
        }

        public void reinitVariableUsageForLevel(int pLevel) {
            this.internalReinitVariableUsageForLevelForCurrentIfStruct(this.mapVariablesPerLevel, pLevel);
        }

        private void internalReinitVariableUsageForLevelForCurrentIfStruct(Map<Integer, Map<String, Integer>> pDataMap, int pLevel) {
            if (pDataMap.get(pLevel) == null) {
                return;
            }
            for (int i = pLevel; i < pDataMap.size(); ++i) {
                pDataMap.remove(i);
            }
        }

        public void reinitVariableUsageForLevelForCurrentIfStruct(int pLevel) {
            this.internalReinitVariableUsageForLevelForCurrentIfStruct(this.mapVariablesPerLevelForCurrentIfStruct, pLevel);
        }

        public void incrementVariableUsageForLevelForCurrentIfStruct(String variableName, int pLevel) {
            this.internalIncrementVariableUsage(this.mapVariablesPerLevelForCurrentIfStruct, variableName, pLevel);
        }

        public Map<String, Integer> getVariablesForCurrentIfStruct(int pLevel) {
            return this.mapVariablesPerLevelForCurrentIfStruct.get(pLevel);
        }
    }
}

