/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC72")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S72")
public class AvoidSQLRequestInLoop
extends IssuableSubscriptionVisitor {
    protected static final String MESSAGERULE = "Avoid SQL request in loop";
    private static final String JAVA_SQL_STATEMENT = "java.sql.Statement";
    private static final String JAVA_SQL_CONNECTION = "java.sql.Connection";
    private static final String SPRING_JDBC_OPERATIONS = "org.springframework.jdbc.core.JdbcOperations";
    private final MethodMatchers SQL_METHOD = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.hibernate.Session"}).names(new String[]{"createQuery", "createSQLQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Statement"}).names(new String[]{"executeQuery", "execute", "executeUpdate", "executeLargeUpdate"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Connection"}).names(new String[]{"prepareStatement", "prepareCall", "nativeSQL"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.persistence.EntityManager"}).names(new String[]{"createNativeQuery", "createQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.jdbc.core.JdbcOperations"}).names(new String[]{"batchUpdate", "execute", "query", "queryForList", "queryForMap", "queryForObject", "queryForRowSet", "queryForInt", "queryForLong", "update"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.jdbc.core.PreparedStatementCreatorFactory"}).names(new String[]{"<init>", "newPreparedStatementCreator"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.jdo.PersistenceManager"}).names(new String[]{"newQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.jdo.Query"}).names(new String[]{"setFilter", "setGrouping"}).withAnyParameters().build()});
    private final AvoidSQLRequestInLoopVisitor visitorInFile = new AvoidSQLRequestInLoopVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT);
    }

    public void visitNode(Tree tree) {
        tree.accept((TreeVisitor)this.visitorInFile);
    }

    private class AvoidSQLRequestInLoopVisitor
    extends BaseTreeVisitor {
        private AvoidSQLRequestInLoopVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (AvoidSQLRequestInLoop.this.SQL_METHOD.matches(tree)) {
                AvoidSQLRequestInLoop.this.reportIssue((Tree)tree, AvoidSQLRequestInLoop.MESSAGERULE);
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

