/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC1")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="GRC1")
public class AvoidSpringRepositoryCallInLoopOrStreamCheck
extends IssuableSubscriptionVisitor {
    protected static final String RULE_MESSAGE = "Avoid Spring repository call in loop or stream";
    private static final String BASE_STREAM = "java.util.stream.BaseStream";
    private static final String SPRING_REPOSITORY = "org.springframework.data.repository.Repository";
    private static final MethodMatchers SPRING_REPOSITORY_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.data.repository.Repository"}).anyName().withAnyParameters().build();
    private static final MethodMatchers STREAM_FOREACH_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.BaseStream"}).names(new String[]{"forEach", "forEachOrdered", "map", "peek"}).withAnyParameters().build();
    private final AvoidSpringRepositoryCallInLoopCheckVisitor visitorInFile = new AvoidSpringRepositoryCallInLoopCheckVisitor();
    private final StreamVisitor streamVisitor = new StreamVisitor();
    private final AncestorMethodVisitor ancestorMethodVisitor = new AncestorMethodVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            if (STREAM_FOREACH_METHOD.matches(methodInvocationTree)) {
                tree.accept((TreeVisitor)this.streamVisitor);
            }
        } else {
            tree.accept((TreeVisitor)this.visitorInFile);
        }
    }

    private class AncestorMethodVisitor
    extends BaseTreeVisitor {
        private AncestorMethodVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (SPRING_REPOSITORY_METHOD.matches(tree)) {
                AvoidSpringRepositoryCallInLoopOrStreamCheck.this.reportIssue((Tree)tree, AvoidSpringRepositoryCallInLoopOrStreamCheck.RULE_MESSAGE);
            } else if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectTree = (MemberSelectExpressionTree)tree.methodSelect();
                if (memberSelectTree.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)memberSelectTree.expression();
                    methodInvocationTree.accept((TreeVisitor)AvoidSpringRepositoryCallInLoopOrStreamCheck.this.ancestorMethodVisitor);
                }
            }
        }
    }

    private class StreamVisitor
    extends BaseTreeVisitor {
        private StreamVisitor() {
        }

        public void visitLambdaExpression(LambdaExpressionTree tree) {
            tree.accept((TreeVisitor)AvoidSpringRepositoryCallInLoopOrStreamCheck.this.ancestorMethodVisitor);
        }
    }

    private class AvoidSpringRepositoryCallInLoopCheckVisitor
    extends BaseTreeVisitor {
        private AvoidSpringRepositoryCallInLoopCheckVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (SPRING_REPOSITORY_METHOD.matches(tree)) {
                AvoidSpringRepositoryCallInLoopOrStreamCheck.this.reportIssue((Tree)tree, AvoidSpringRepositoryCallInLoopOrStreamCheck.RULE_MESSAGE);
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

